<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Msg_Flag_Master;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Laracasts\Flash\Flash;

class FlagController extends Controller
{
    public function index()
    {
        $flags = Msg_Flag_Master::with(['msg','userBy','msgUser'])->whereHas('msg')
            ->whereHas('userBy')->whereHas('msgUser')
            ->get();
        
        return view('admin.flags.index', compact('flags'))
            ->with('i', (request()->input('page', 1) - 1) * 5);
    }
    
    public function userNotify(Request $request)
    {
        $input = $request->all();
        Msg_Flag_Master::where('mf_id',$input['mf_id'])->update([
            'notify_msg'=>$input['notify_msg'],
            'notify_read'=>0,
        ]);
        
        Flash::success('Notify to user successfully.');
        return redirect(route('flags.index'));
    }
}
