<?php

namespace App\Http\Controllers\Api;

use App\Models\Apple_User_Master;
use App\Models\Block_Master;
use App\Models\Message_Master;
use App\Models\Msg_Flag_Master;
use App\Models\Otp_Master;
use App\Models\Unique_Id_master;
use App\Models\User_Master;
use Illuminate\Http\Request;
use App\Models\Key_Token_Master;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\AppBaseController;

class FeatureApiController extends AppBaseController
{
    public function searchPage(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
            ]);
            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter').$valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }
            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, trans('words.invalid_user_id'));
            }

            $blockUserIds = Block_Master::where('user_by', $user_id)->pluck('user_to')->toArray();
            $usersQ = User_Master::query()->where('user_id','<>',$user_id)
                ->whereNotIn('user_id', $blockUserIds);
            if(isset($name_or_id)){
                $usersQ->where(function ($q)use($name_or_id){
                    $q->orWhere('fname',$name_or_id)->orWhere('unique_id',$name_or_id);
                });
            }if(isset($gender)){
                $usersQ->where('gender',$gender);
            }if(isset($age)){
                $usersQ->where('age',$age);
            }if(isset($i_am)){
                $usersQ->where('i_am',$i_am);
            }if(isset($i_live)){
                $usersQ->where('i_live',$i_live);
            }if(isset($spoken)){
                $usersQ->whereRaw("spoken REGEXP '(^|,)(" . str_replace(',', '|', $spoken) . ")(,|$)'");
            }

            $users = $usersQ->get();
            $data['data'] = $users;
            return $this->successResponse($data, 1, __('words.list_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function blockUnBlockUser(Request $request)
    {
        try {
            $input = $request->all();
            extract($input);

            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
                'user_to' => @$user_to,
            ]);
            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter').$valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }
            $user_by = $user_id;
            $userBy = User_Master::where('user_id', $user_by)->first();
            if (empty($userBy)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }
            $userTo = User_Master::where('user_id', $user_to)->first();
            if (empty($userTo)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }

            $blockUser = Block_Master::where([
                'user_by' => $user_by,
                'user_to' => $user_to,
            ])->first();
            if ($blockUser) {
                $blockUser->delete();
                $list['is_block'] = 0;
                $resMsg = __('words.user_unblock');
            }else{
                Block_Master::create([
                    'user_by' => $user_by,
                    'user_to' => $user_to,
                ]);
                $list['is_block'] = 1;
                $resMsg = __('words.user_block');
            }
            $data['data'] = $list;

            return $this->successResponse($data, 1, $resMsg, 'True');
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function getBlockUsers(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
            ]);
            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter').$valid);
            }

            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, trans('words.invalid_user_id'));
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $blockUserIds = Block_Master::where('user_by', $user_id)->pluck('user_to')->toArray();
            $users = User_Master::select('user_id', 'fname', 'unique_id')->whereIn('user_id',
                $blockUserIds)->orderBy('fname')->get();

            $data['data'] = $users;

            return $this->successResponse($data, 1, __('words.list_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function addFlagToMsg(Request $request)
    {
        try {
            $input = $request->all();
            extract($input);

            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
                'msg_id' => @$msg_id,
                'notes' => @$notes,
            ]);
            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter').$valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }
            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }
            $msg = Message_Master::where('msg_id', $msg_id)->first();
            if (empty($msg)) {
                return $this->responseError(0, __('words.invalid_msg_id'));
            }

            Msg_Flag_Master::create([
                'user_by'=> $user_id,
                'msg_id'=> $msg_id,
                'msg_user_id'=> $msg->sender_id,
                'notes'=> $notes,
            ]);

            return $this->responseSuccess(1, __('words.msg_flag'));
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function sendChatMedia(Request $request)
    {
        try{
            extract($request->all());
            $valid = $this->requiredValidation([
                'media' => @$media,
                "user_id"=>@$user_id,
                "receiver_id"=>@$receiver_id,
            ]);
            if($valid != ''){
                $msg = trans('words.please_enter').$valid;
                return $this->responseError(0, $msg);
            }
            $checkBlock = Block_Master::where(function($query) use ($user_id, $receiver_id) {
            $query->where('user_by', $user_id)
                  ->where('user_to', $receiver_id);
            })->orWhere(function($query) use ($user_id, $receiver_id) {
            $query->where('user_by', $receiver_id)
                  ->where('user_to', $user_id);
            })->first();
            if(!empty($checkBlock)){
                return $this->responseError(0, __('words.block_user'));
            }
            $mediaRow = [];
            if (isset($_FILES['media'])) {
                $mediaName = time().uniqid().'.'.$media->getClientOriginalExtension();
                $media->move(public_path('chat'), $mediaName);
                $mediaRow['name'] = $mediaName;
                $mediaRow['media'] = env('PUBLIC_PATH').'chat/'.$mediaName;
            }else{
                return $this->responseError(0, __('words.please_enter').'media');
            }

            $data['data'] = $mediaRow;

            return  AppBaseController::successResponse($data, 1, __('words.success'), "True");
        } catch(\Exception $e){
            return AppBaseController::responseError(0, $e->getMessage());
        }
    }

    public function getAdminNotification(Request $request){
        try {
            $input = $request->all();
            extract($input);

            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
            ]);
            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter').$valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }
            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }

            $msgFlagsData = Msg_Flag_Master::where([
                'user_by'=> $user_id,
                'notify_read'=> 0,
            ])->select('notify_msg','mf_id')->get();

            $data['data']['flag_notifies']=$msgFlagsData;
            return $this->successResponse($data,1, __('words.list_success'),'True');
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }
    public function readAdminNotification(Request $request){
        try {
            $input = $request->all();
            extract($input);

            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
                'mf_id' => @$mf_id,
            ]);

            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter').$valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }
            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }

            $msgFlagQ = Msg_Flag_Master::where([
                'user_by'=> $user_id,
                'mf_id'=> $mf_id,
            ])->first();
            if(!$msgFlagQ){
                return $this->responseError(0, __('words.invalid_notify'));
            }

            $msgFlagQ->update(['notify_read'=>1]);

            return $this->responseSuccess(1, __('words.success'),'True');
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function msgDelete(Request $request){
        try {
            $input = $request->all();
            extract($input);

            $valid = $this->requiredValidation([
                'msg_id' => @$msg_id,
            ]);

            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter').$valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }
            $msg = Message_Master::where('msg_id', $msg_id)->first();
            if (empty($msg)) {
                return $this->responseError(0, __('words.invalid_msg_id'));
            }

            Msg_Flag_Master::where(['msg_id'=> $msg_id])->delete();
            $msg->delete();

            return $this->responseSuccess(1, __('words.success'),'True');
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }
}
