<?php

namespace App\Http\Controllers\Api;

use App\Models\Apple_User_Master;
use App\Models\Otp_Master;
use App\Models\Unique_Id_master;
use App\Models\User_Master;
use Illuminate\Http\Request;
use App\Models\Key_Token_Master;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\AppBaseController;

class UserApiController extends AppBaseController
{
    public function getVoiceBuddiesID()
    {
        try {
            $uniqueId = uniqueId(7);
            Unique_Id_master::create([
                'unique_id' => $uniqueId
            ]);

            $data['data']['unique_id'] = $uniqueId;

            return $this->successResponse($data, 1, __('words.list_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function sendOtp(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'email' => @$email,
            ]);
            if (! empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }
            $user = User_Master::where('email', $email)->first();
            if ($user) {
                return $this->responseError(0, trans('words.already_register'));
            }

            $otp = CommonController::generateOtp();
            $otpDtl = OTP_Master::where('email', $email)->first();
            if ($otpDtl) {
                $otpDtl->update(['otp' => $otp]);
            } else {
                OTP_Master::create([
                    'otp'   => $otp,
                    'email' => $email,
                ]);
            }

            $data['otp'] = $otp;
            if (config('app.is_send_otp')) {
                CommonController::sendOtpEmail($email, $otp);
            }

            return $this->successResponse($data, 1, __('words.otp_send_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function signUp(Request $request)
    {
        try {
            extract($request->all());

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $device_type = empty($device_type) ? "" : $device_type;
            $device_token = empty($device_token) ? "" : $device_token;

            $valid = $this->requiredValidation([
                'unique_id' => @$unique_id,
                'fname'     => @$fname,
                'email'     => @$email,
                'password'  => @$password,
                'gender'    => @$gender,
                'age'       => @$age,
                'i_am'      => @$i_am,
                'i_live'    => @$i_live,
                'spoken'    => @$spoken,
                'voice'     => @$voice,
                'otp'       => @$otp,
            ]);
            if ($valid != '') {
                $msg = trans('words.please_enter') . $valid;
                return $this->responseError(0, $msg);
            }

            $isId = Unique_Id_master::where('unique_id', $unique_id)->first();
            if (!$isId) {
                return $this->responseError(0, trans('words.invalid_unique_id'));
            }
            $user = User_Master::where('unique_id', $unique_id)->first();
            if ($user) {
                return $this->responseError(0, trans('words.already_unique_id'));
            }
            $user = User_Master::where('email', $email)->first();
            if ($user) {
                return $this->responseError(0, trans('words.already_register'));
            }

            // verify otp

            if (isset($phone)) {
                $otpDtl = OTP_Master::where('phone', $phone)->first();
                if (empty($otpDtl)) {
                    return $this->responseError(0, __('words.otp_resend'));
                }
            } else {
                $otpDtl = OTP_Master::where('email', $email)->first();
                if (empty($otpDtl)) {
                    return $this->responseError(0, __('words.otp_resend'));
                }
            }
            if ($otpDtl->otp != $otp) {
                return $this->responseError(0, __('words.otp_invalid'));
            }

            $voiceName = time() . uniqid() . '.' . $request->voice->getClientOriginalExtension();
            $request->voice->move(public_path('voices'), $voiceName);
            $generate_token = CommonController::RandomStringGenerator();

            $ccode = isset($ccode) ? $ccode : "";
            $phone = isset($phone) ? $phone : "";

            $insert = [
                'unique_id'    => $unique_id,
                'fname'        => $fname,
                'email'        => $email,
                'pass'         => $password,
                'gender'       => $gender,
                'age'          => $age,
                'i_am'         => $i_am,
                'i_live'       => $i_live,
                'spoken'       => $spoken,
                'voice'        => $voiceName,
                'device_type'  => $device_type,
                'device_token' => $device_token,
                'ccode' => $ccode,
                'phone' => $phone,
            ];

            $user_detail = User_Master::create($insert);
            Key_Token_Master::create([
                'key' => $key,
                'token' => $generate_token
            ]);
            if (isset($otpDtl)) {
                $otpDtl->delete();
            }

            $data['data'] = $this->getUserDtl($user_detail, $generate_token);

            return $this->successResponse($data, 1, __('words.register_complete'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function getUserDtl($userDetail, $generateToken)
    {
        $userDetail->token = $generateToken;
        if (isset($userDetail->id)) {
            $userDetail->user_id = $userDetail->id;
            unset($userDetail->id);
        }

        return $userDetail;
    }

    public function login(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'email' => @$email,
                'password' => @$password,
            ]);
            if (!empty($valid)) {
                $msg = __('words.please_enter') . $valid;
                return $this->responseError(0, $msg);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $device_token = empty($device_token) ? "" : $device_token;
            $device_type = empty($device_type) ? "" : $device_type;

            // $user = User_Master::where('email', $email)->first();
            // if (empty($user)) {
            //     return $this->responseError(0, __('words.incorrect_email'));
            // }

            $user = User_Master::where(function ($query) use ($email) {
                $query->where('email', $email)
                    ->orWhere('phone', $email);
            })->first();

            if (empty($user)) {
                return $this->responseError(0, trans('words.phone_or_email_not_registered'));
                // return $this->responseError(0, trans('words.not_registered'));
            }

            if ($user->pass != $password) {
                return $this->responseError(0, __('words.incorrect_password'));
            }

            if ($user->is_verify == 0) {
                return $this->responseError(0, __('words.verify_account'));
            }

            $updateObj = ['device_type' => $device_type, 'device_token' => $device_token];
            $user->update($updateObj);

            $tokenDtl = Key_Token_Master::orderBy(DB::raw('RAND()'))->first();

            $data['data'] = $this->getUserDtl($user, $tokenDtl->token);

            return $this->successResponse($data, 1, __('words.login_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function logOut(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $user = User_Master::where('user_id', $user_id)->first();

            if (empty($user)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }

            $user->update(['device_token' => '']);

            return $this->responseSuccess(1, 'Log out successfully');
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function updateProfile(Request $request)
    {
        try {
            $input = $request->all();
            extract($input);
            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, trans('words.invalid_user_id'));
            }

            $input = fltNullArr($input);
            if (!empty($voice)) {
                $voiceName = time() . uniqid() . '.' . $request->voice->getClientOriginalExtension();
                $request->voice->move(public_path('voices'), $voiceName);
                $input['voice'] = $voiceName;
                // old img remove
                unlinkStorageFile($user->voice, 'voices');
            }

            $user->update($input);

            $tokenDtl = Key_Token_Master::orderBy(DB::raw('RAND()'))->first();

            $data['data'] = $this->getUserDtl($user, $tokenDtl->token);

            return $this->successResponse($data, 1, __('words.profile_update'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function getUserProfile(Request $request)
    {
        try {
            $input = $request->all();
            extract($input);
            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, trans('words.invalid_user_id'));
            }

            $data['data'] = $user;

            return $this->successResponse($data, 1, __('words.list_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function changePassword(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
                'old_password' => @$old_password,
                'new_password' => @$new_password
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }

            if ($new_password == $user->pass) {
                return $this->responseError(0, __('words.check_password'));
            } elseif ($user->pass == $old_password) {
                $updatePwd = $user->update(['pass' => $new_password]);

                return $this->responseSuccess(1, __('words.password_change_success'));
            } else {
                return $this->responseError(0, __('words.check_old_password'));
            }
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function forgotPassword(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'email' => @$email
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $user = User_Master::where('email', $email)->first();

            if (empty($user)) {
                return $this->responseError(0, __('words.not_registered'));
            }

            $otp = CommonController::generateOtp();
            $otpDtl = OTP_Master::where('email', $email)->first();
            if ($otpDtl) {
                $otpDtl->update(['otp' => $otp]);
            } else {
                OTP_Master::create([
                    'otp'   => $otp,
                    'email' => $email,
                ]);
            }

            CommonController::mailForForgotPassword($email, $otp);
            $data['otp'] = $otp;

            return $this->successResponse($data, 1, __('words.otp_send_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    /**
     * @param Request $request
     * @return mixed
     */
    public function verifyOtp(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'email' => @$email,
                'otp' => @$otp,
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            $user = User_Master::where('email', $email)->first();
            if (empty($user)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }

            $otpDtl = OTP_Master::where('email', $email)->first();
            if (empty($otpDtl)) {
                return $this->responseError(0, __('words.otp_resend'));
            }
            if ($otpDtl->otp != $otp) {
                return $this->responseError(0, __('words.otp_invalid'));
            }
            $otpDtl->delete();

            return $this->responseSuccess(1, __('words.otp_verified'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function updatePassword(Request $request)
    {
        extract($request->all());
        $key = $request->header('key');
        $valid = $this->requiredValidation([
            'email' => @$email,
            'password' => @$password,
        ]);
        if (!empty($valid)) {
            return $this->responseError(0, __('words.please_enter') . $valid);
        }

        $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
        $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
        if (CommonController::versionCheck($devicetype, $versioncode)) {
            return $this->responseError(26, __('words.update_app_msg'));
        }
        if (CommonController::checkKeyExist($key) == 0) {
            return $this->responseError(0, __('words.incorrect_key'));
        }

        $user = User_Master::where('email', $email)->first();
        if (empty($user)) {
            return $this->responseError(0, trans('words.invalid_user_id'));
        }

        //        $otpDtl = OTP_Master::where('email', $email)->first();
        //        if (empty($otpDtl)){
        //            return $this->responseError(0, __('words.otp_resend'));
        //        }
        //        if($otpDtl->otp != $otp) {
        //            return $this->responseError(0, __('words.otp_invalid'));
        //        }
        //        $otpDtl->delete();

        $user->update(['pass' => $password]);

        return $this->responseSuccess(1, __('words.password_reset_success'), "True");
    }

    public function contactUs(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'name' => @$name,
                'email' => @$email,
                'subject' => @$subject,
                'message' => @$message
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, __('words.update_app_msg'));
            }

            CommonController::mailContactUs($name, $email, $subject, $message);
            return $this->responseSuccess(1, "Thank you for contacting " . env('APP_NAME') . ". We will get back to you shortly.");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function deleteAccount(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'user_id' => @$user_id,
                'reason' => @$reason,
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $user = User_Master::where('user_id', $user_id)->first();
            if (empty($user)) {
                return $this->responseError(0, __('words.invalid_user_id'));
            }

            $user->update([
                'is_delete' => 1,
                'delete_reason' => isset($reason) ? $reason : ''
            ]);

            return $this->responseSuccess(1, __('words.user_deleted'));
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }
    public function checkEmail(Request $request)
    {
        try {
            extract($request->all());
            $valid = $this->requiredValidation([
                'email' => @$email,
            ]);
            if (!empty($valid)) {
                return $this->responseError(0, __('words.please_enter') . $valid);
            }

            $user = User_Master::where('email', $email)->first();
            if (empty($user)) {
                return $this->responseError(1, __('words.incorrect_email'));
            } else {
                return $this->responseSuccess(0, __('words.already_register'));
            }

            if (isset($phone)) {
                $userPhone = User_Master::where('phone', $phone)->first();
                if (empty($userPhone)) {
                    return $this->responseError(1, __('words.incorrect_phone'));
                } else {
                    return $this->responseSuccess(0, __('words.already_register_phone'));
                }
            }
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function testsleep()
    {
        $url = env('APP_URL') . '/api/testbgfun/10';
        $data = CommonController::backgroundPostLocal($url);
        echo $data;
    }

    public function importCSVdata(Request $request)
    {
        $filesData = $this->csvToArray($request['csv_file']);
        // print_r($filesData);
    }

    function csvToArray($filename = '', $delimiter = ',')
    {
        if (!file_exists($filename) || !is_readable($filename))
            return false;
        $header = null;
        $data = array();
        if (($handle = fopen($filename, 'r')) !== false) {
            while (($row = fgetcsv($handle, 1000, $delimiter)) !== false) {
                if (!$header)
                    $header = $row;
                else
                    $data[] = array_combine($header, $row);
            }
            fclose($handle);
        }
        return $data;
    }

    public function sendOTPPhone(Request $request)
    {
        try {
            extract($request->all());

            $valid = $this->requiredValidation([
                'ccode' => @$ccode,
                'phone' => @$phone,
            ]);

            if ($valid != '') {
                $msg = trans('words.please_enter') . $valid;
                return $this->responseError(0, $msg);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, trans('words.update_app_msg'));
            }

            $phoneExist = User_Master::where(['phone' => $phone])->first();
            if (!empty($phoneExist)) {
                return $this->responseError(0, trans('words.already_register_phone'));
            }

            $otpCheck = Otp_Master::where(['phone' => $phone])->first();
            $otp = substr(number_format(time() * rand(), 0, '', ''), 0, 4);

            if (empty($otpCheck)) {
                Otp_Master::create(['phone' => $phone, 'ccode' => $ccode, 'otp' => $otp]);
            } else {
                Otp_Master::where(['phone' => $phone])->update(['otp' => $otp]);
            }

            // $sendMail = CommonController::mailForSendOtp($email, $otp);
            $phone_num = "+" . $ccode . $phone;
            $message = "Your verification code for " . env('APP_NAME') . " is " . $otp . ". Please enter this code to complete your registration. Do not share this code with anyone.";
            AppBaseController::sendTwilioMessage($phone_num, $message);
            // AppBaseController::sendInfoBIBMessage($phone_num, $message);
            $data['data'] = ['phone' => $phone, 'ccode' => $ccode, 'otp' => $otp];
            // $data['data'] = ['phone' => $phone, 'ccode' => $ccode];

            return $this->successResponse($data, 1, trans('words.otp_send_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function forgotPasswordPhone(Request $request)
    {
        try {
            extract($request->all());

            $valid = $this->requiredValidation([
                'ccode' => @$ccode,
                'phone' => @$phone,
            ]);

            if ($valid != '') {
                $msg = trans('words.please_enter') . $valid;
                return $this->responseError(0, $msg);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, trans('words.update_app_msg'));
            }

            $user = User_Master::where(['phone' => $phone])->first();
            if (empty($user)) {
                return $this->responseError(0, trans('words.not_registered_phone'));
            } else if ($user->ccode != $ccode) {
                return $this->responseError(0, trans('words.ccode_not_match'));
            }

            $phoneExist = Otp_Master::where(['phone' => $phone])->first();
            $otp = substr(number_format(time() * rand(), 0, '', ''), 0, 4);

            if (empty($phoneExist)) {
                Otp_Master::create(['phone' => $phone, 'otp' => $otp, 'ccode' => $ccode]);
            } else {
                Otp_Master::where(['phone' => $phone])->update(['otp' => $otp]);
            }

            $phone_num = "+" . $ccode . $phone;
            $message = "Your verification code for " . env('APP_NAME') . " is " . $otp . ". Please enter this code to forgot password. Do not share this code with anyone.";
            AppBaseController::sendTwilioMessage($phone_num, $message);

            $data['data'] = User_Master::select('ccode', 'phone')->where(['phone' => $phone])->first();
            $data['data']['otp'] = $otp;

            return $this->successResponse($data, 1, trans('words.otp_send_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function verifyForgotPasswordOTPPhone(Request $request)
    {
        try {
            extract($request->all());

            $valid = $this->requiredValidation([
                'ccode' => @$ccode,
                'phone' => @$phone,
                'otp' => @$otp,
            ]);

            if ($valid != '') {
                $msg = trans('words.please_enter') . $valid;
                return $this->responseError(0, $msg);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, trans('words.update_app_msg'));
            }

            $user = User_Master::where(['phone' => $phone])->first();
            $otpCheck = Otp_Master::where(['phone' => $phone])->first();
            if (empty($user)) {
                return $this->responseError(0, trans('words.not_registered_phone'));
            } else if ($user->ccode != $ccode) {
                return $this->responseError(0, trans('words.ccode_not_match'));
            } else if (empty($otpCheck)) {
                return $this->responseError(0, trans('words.otp_invalid'));
            } else if ($otpCheck->otp != $otp) {
                return $this->responseError(0, trans('words.otp_invalid'));
            }

            return $this->responseSuccess(1, trans('words.otp_verified'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }

    public function updatePasswordPhone(Request $request)
    {
        try {
            extract($request->all());

            $valid = $this->requiredValidation([
                'ccode' => @$ccode,
                'phone' => @$phone,
                'new_pass' => @$new_pass,
            ]);

            if ($valid != '') {
                $msg = trans('words.please_enter') . $valid;
                return $this->responseError(0, $msg);
            }

            $devicetype = empty($_SERVER["HTTP_DEVICETYPE"]) ? "" : $_SERVER["HTTP_DEVICETYPE"];
            $versioncode = empty($_SERVER["HTTP_VERSIONCODE"]) ? "" : $_SERVER["HTTP_VERSIONCODE"];
            if (CommonController::versionCheck($devicetype, $versioncode)) {
                return $this->responseError(26, trans('words.update_app_msg'));
            }

            $user = User_Master::where(['phone' => $phone])->first();
            if (empty($user)) {
                return $this->responseError(0, trans('words.not_registered'));
            } else if ($user->ccode != $ccode) {
                return $this->responseError(0, trans('words.ccode_not_match'));
            }

            // $otpCheck = Otp_Master::where(['phone' => $phone])->first();
            // if (empty($otpCheck)) {
            //     return $this->responseError(0, trans('words.otp_invalid'));
            // }

            User_Master::where(['phone' => $phone])->update(['password' => $new_pass]);
            return $this->responseSuccess(1, trans('words.update_pass_success'), "True");
        } catch (\Exception $e) {
            return $this->responseError(0, $e->getMessage());
        }
    }
}
