<?php

namespace App\Http\Middleware;

use App\Http\Controllers\AppBaseController;
use App\Http\Controllers\CommonController;
use Closure;
use Illuminate\Http\Request;

class RequestKeyToken extends AppBaseController
{
    /**
     * @param Request $request
     * @param Closure $next
     *
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $key = $request->header('key');
        $token = $request->header('token');
        $valid = $this->requiredValidation([
            'key' => $key,
            'token' => $token
        ]);
        if (!empty($valid)) {
            $msg = trans('words.please_enter') . $valid;

            return $this->responseError(0, $msg);
        }

        if (CommonController::checkKeyExist($key) == 0) {
            return $this->responseError(0, __('words.incorrect_key'));
        } else if (CommonController::checkKeyTokenExist($key, $token) == 0) {
            return $this->responseError(0, __('words.incorrect_token'));
        }

        $request->request->add(['key' => $key]);

        return $next($request);
    }
}
