<?php

use App\Models\Unique_Id_master;

/**
 *
 *
 * @return string
 */
function homeUrl(): string
{
    return route('admin.dashboard');
}

/**
 * @param $url
 *
 *
 * @return string
 */
function assetUrl($url): string
{
    return env('PUBLIC_PATH').$url;
}

/**
 * @param $name
 * @param $path
 *
 *
 * @return bool
 */
function unlinkStorageFile($name, $path){
    if(empty($name)){
        return true;
    }
    $fileName = str_replace(env('PUBLIC_PATH').$path.'/', '', $name);
    $storageFile = public_path($path) . '/' . $fileName;
    if (file_exists($storageFile)) {
        unlink($storageFile);
    }

    return true;
}

/**
 * @param $limit
 *
 *
 * @return string
 */
function uniqueId($limit)
{
    $uniqueId= substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);
    $uniqueId = strtoupper($uniqueId);
    $is = Unique_Id_master::where('unique_id', $uniqueId)->exists();
    if($is){
        $uniqueId = uniqueId(7);
    }
    return $uniqueId;
}

/**
 * @param $arrData
 *
 *
 * @return array
 */
function fltNullArr($arrData): array
{
    return array_map(function ($v) {
        return $v == null ? '' : $v;
    }, $arrData);

}
