<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_master', function (Blueprint $table) {
            $table->id('user_id');
            $table->string('full_name', 100);
            $table->string('email', 150);
            $table->string('phone', 60)->default('');
            $table->string('password', 70);
            $table->string('profile',150);
            $table->integer('is_fb')->default(0);
            $table->string('fb_id')->default('');
            $table->integer('is_google')->default(0);
            $table->string('google_id')->default('');
            $table->integer('is_apple')->default(0);
            $table->string('apple_id')->default('');
            $table->string('device_type',50);
            $table->string('device_token', 255)->default('');
            $table->string('lat',60)->default('');
            $table->string('lng', 60)->default('');
            $table->boolean('is_delete')->default(0);
            $table->string('delete_reason')->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_master');
    }
}
