<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMessageMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('message_master', function (Blueprint $table) {
            $table->id('msg_id');
            $table->string('msg_type', 100);
            $table->unsignedBigInteger('sender_id');
            $table->unsignedBigInteger('receiver_id');
            $table->text('msg');
            $table->boolean('is_read')->default(0);
            $table->timestamps();

            $table->foreign('sender_id')->references('user_id')->on('user_master')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('receiver_id')->references('user_id')->on('user_master')
                ->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('message_master');
    }
}
