<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationMasterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notification_master', function (Blueprint $table) {
            $table->id('notify_id');
            $table->unsignedBigInteger('user_by');
            $table->unsignedBigInteger('user_to');
            $table->unsignedBigInteger('model_id');
            $table->string('model_name');
            $table->timestamps();

            $table->foreign('user_by')->references('user_id')->on('user_master')
                ->onUpdate('cascade')->onDelete('cascade');
            $table->foreign('user_to')->references('user_id')->on('user_master')
                ->onUpdate('cascade')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notification_master');
    }
}
