<?php

namespace Database\Seeders;

use App\Http\Controllers\CommonController;
use App\Models\Key_Master;
use App\Models\Key_Token_Master;
use App\Models\User;
use App\Models\Version_Master;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class DefaultDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
       $key = Key_Master::create([
            'key_name' => Str::random(42),
        ]);
       
       Key_Token_Master::create([
          'key' => $key->key_name ,
          'token' => CommonController::RandomStringGenerator()
       ]);

        $versions = [
            [
                'device_type'  => 'android',
                'version_code' => 4,
            ], [
                'device_type'  => 'iOS',
                'version_code' => 1,
            ],
        ];
        foreach ($versions as $version) {
            Version_Master::create($version);
        }
        
        User::create([
            'name' => 'Admin',
            'email' => 'admin@gmail.com',
            'email_verified_at' => Carbon::now(),
            'password' => Hash::make('12345678'),
            'profile' => '165529162262a9bee63a097.jpg',
        ]);
    }
}
