<?php

use App\Http\Controllers\Admin\FlagController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\FeatureController;
use App\Http\Controllers\RegisterController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Rawilk\Printing\Facades\Printing;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('helper-test', function () {
    dd(helperTest());
});

Route::get('/clear-cache', function () {
    Artisan::call('optimize:clear');
});

Route::get('mail', [RegisterController::class, 'getVerifyMail']);
Route::get('resetPwd', [RegisterController::class, 'resetPwdMail']);
Route::get('resetPwdMail1', [RegisterController::class, 'resetPwdMail1']);
Route::get('resetPwdDone', [RegisterController::class, 'resetPwdDone']);
Route::get('fun', [RegisterController::class, 'document']);

Route::prefix('admin')->as('admin.')->group(function () {
    Auth::routes();
});

Route::middleware(['preventBackHistory', 'auth'])->group(function () {

    Route::get('admin/dashboard', [App\Http\Controllers\HomeController::class, 'dashboard'])->name('admin.dashboard');

    Route::post('admin/logout', [LoginController::class, 'logout'])->name('admin.logout');
    
    Route::get('admin/users', [UserController::class, 'index'])->name('admin.user');
    Route::post('admin/verifyUserAccount', [UserController::class,'verifyUserAccount'])->name('admin.verifyUserAccount');
    Route::get('admin/flags', [FlagController::class, 'index'])->name('flags.index');
    Route::post('admin/flags/notify', [FlagController::class, 'userNotify'])->name('flags.userNotify');

});

Route::get('about-us', [FeatureController::class,'aboutUs'])->name('about_us');
Route::get('privacy-policy', [FeatureController::class,'privacyPolicy'])->name('privacy_policy');
Route::get('terms-conditions', [FeatureController::class,'termsConditions'])->name('terms_conditions');
Route::get('test-chat', [FeatureController::class, 'testChat']);
