export type { Breadcrumb, BreadcrumbHint, PolymorphicRequest, Request, SdkInfo, Event, EventHint, Exception, Session, Severity, SeverityLevel, Span, StackFrame, Stacktrace, Thread, Transaction, User, } from '@sentry/types';
export type { AddRequestDataToEventOptions } from '@sentry/utils';
export type { TransactionNamingScheme } from './requestdata';
export type { NodeOptions } from './types';
export { addGlobalEventProcessor, addBreadcrumb, addIntegration, captureException, captureEvent, captureMessage, close, configureScope, createTransport, extractTraceparentData, flush, getActiveTransaction, getHubFromCarrier, getCurrentHub, Hub, lastEventId, makeMain, runWithAsyncContext, Scope, startTransaction, SDK_VERSION, setContext, setExtra, setExtras, setTag, setTags, setUser, spanStatusfromHttpCode, trace, withScope, captureCheckIn, withMonitor, setMeasurement, getActiveSpan, startSpan, startActiveSpan, startInactiveSpan, startSpanManual, continueTrace, } from '@sentry/core';
export type { SpanStatusType } from '@sentry/core';
export { autoDiscoverNodePerformanceMonitoringIntegrations } from './tracing';
export { NodeClient } from './client';
export { makeNodeTransport } from './transports';
export { defaultIntegrations, init, defaultStackParser, getSentryRelease } from './sdk';
export { addRequestDataToEvent, DEFAULT_USER_INCLUDES, extractRequestData } from './requestdata';
export { deepReadDirSync } from './utils';
export { getModuleFromFilename } from './module';
export { enableAnrDetection } from './anr';
import { Integrations as CoreIntegrations } from '@sentry/core';
import * as Handlers from './handlers';
import * as NodeIntegrations from './integrations';
import * as TracingIntegrations from './tracing/integrations';
declare const INTEGRATIONS: {
    Apollo: typeof TracingIntegrations.Apollo;
    Express: typeof TracingIntegrations.Express;
    GraphQL: typeof TracingIntegrations.GraphQL;
    Mongo: typeof TracingIntegrations.Mongo;
    Mysql: typeof TracingIntegrations.Mysql;
    Postgres: typeof TracingIntegrations.Postgres;
    Prisma: typeof TracingIntegrations.Prisma;
    Console: typeof NodeIntegrations.Console;
    Http: typeof NodeIntegrations.Http;
    OnUncaughtException: typeof NodeIntegrations.OnUncaughtException;
    OnUnhandledRejection: typeof NodeIntegrations.OnUnhandledRejection;
    LinkedErrors: typeof NodeIntegrations.LinkedErrors;
    Modules: typeof NodeIntegrations.Modules;
    ContextLines: typeof NodeIntegrations.ContextLines;
    Context: typeof NodeIntegrations.Context;
    RequestData: typeof NodeIntegrations.RequestData;
    LocalVariables: typeof NodeIntegrations.LocalVariables;
    Undici: typeof NodeIntegrations.Undici;
    FunctionToString: typeof CoreIntegrations.FunctionToString;
    InboundFilters: typeof CoreIntegrations.InboundFilters;
};
export { INTEGRATIONS as Integrations, Handlers };
//# sourceMappingURL=index.d.ts.map