"use strict";
exports.id = 831;
exports.ids = [831];
exports.modules = {

/***/ 52369:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.processCommandArgs = void 0;
function processCommandArgs(...args) {
    let options = {};
    if (typeof args[args.length - 1] === 'object') {
        options = args.pop();
    }
    args = args.filter(Boolean);
    // For repository scanning, populate with default path (cwd) if no path given
    if (args.length === 0 && !options.docker) {
        args.unshift(process.cwd());
    }
    return { options, paths: args };
}
exports.processCommandArgs = processCommandArgs;


/***/ }),

/***/ 87831:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const process_command_args_1 = __webpack_require__(52369);
const legacyError = __webpack_require__(79407);
const fs = __webpack_require__(57147);
const snykPolicyLib = __webpack_require__(70535);
const get_iac_org_settings_1 = __webpack_require__(11693);
const assert_iac_options_flag_1 = __webpack_require__(33111);
const config_1 = __webpack_require__(25425);
const drift_1 = __webpack_require__(26445);
const analytics = __webpack_require__(82744);
exports["default"] = async (...args) => {
    var _a, _b;
    const { options } = process_command_args_1.processCommandArgs(...args);
    // Ensure that this update-exclude-policy command can only be runned when using `snyk iac update-exclude-policy`
    // Avoid `snyk update-exclude-policy` direct usage
    if (options.iac != true) {
        return legacyError('update-exclude-policy');
    }
    // Ensure that we are allowed to run that command
    // by checking the entitlement
    const orgPublicId = (_a = options.org) !== null && _a !== void 0 ? _a : config_1.default.org;
    const iacOrgSettings = await get_iac_org_settings_1.getIacOrgSettings(orgPublicId);
    if (!((_b = iacOrgSettings.entitlements) === null || _b === void 0 ? void 0 : _b.iacDrift)) {
        throw new assert_iac_options_flag_1.UnsupportedEntitlementCommandError('update-exclude-policy', 'iacDrift');
    }
    try {
        // There's an open bug for this in Windows in the current version of node when called with no stdinput.
        // See https://github.com/nodejs/node/issues/19831
        // The actual error handling behavior is enough for now but may be improved if needed
        const analysis = drift_1.parseDriftAnalysisResults(fs.readFileSync(0).toString());
        // Add analytics
        analytics.add('is-iac-drift', true);
        let policy;
        try {
            policy = await snykPolicyLib.load();
        }
        catch (error) {
            if (error.code === 'ENOENT') {
                // policy file does not exist - create it
                policy = await snykPolicyLib.create();
            }
            else {
                throw error;
            }
        }
        await drift_1.updateExcludeInPolicy(policy, analysis, options);
        await snykPolicyLib.save(policy);
    }
    catch (e) {
        const err = new Error('Error running `iac update-exclude-policy` ' + e);
        return Promise.reject(err);
    }
};


/***/ })

};
;
//# sourceMappingURL=831.index.js.map