"use strict";
exports.id = 989;
exports.ids = [989];
exports.modules = {

/***/ 60959:
/***/ ((__unused_webpack_module, exports) => {


/**
 * The content of this file is generated by a tool.
 * Don't edit it manually!
 * */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.vulnerableSignatures = void 0;
exports.vulnerableSignatures = {
    IfBVtiwVRT8NeXCp2ZTKtw: {
        filename: 'JndiManager.class',
        versions: ['2.13.2', '2.13.1', '2.13.0', '2.13.3'],
    },
    CsWz5uabp3ZWg3mOZpowsg: {
        filename: 'log4j-core-2.13.2.jar',
        versions: ['2.13.2'],
    },
    '8MQ62soq/HHGzID4UbOIGA': {
        filename: 'log4j-core-2.4.1.jar',
        versions: ['2.4.1'],
    },
    RyyOH7qg5hUg4CXCVbXRaA: {
        filename: 'log4j-core-2.6.2.jar',
        versions: ['2.6.2'],
    },
    '7Q4xglxv2kNCP7ODV6QrPQ': {
        filename: 'MessagePatternConverter.class',
        versions: ['2.16.0'],
    },
    geBDOuAGAsDk0AQk0hOwqw: {
        filename: 'log4j-core-2.15.0.jar',
        versions: ['2.15.0'],
    },
    'miPB9v/sgl70HMwQVBogkA': {
        filename: 'JndiManager.java',
        versions: ['2.8.2-sources', '2.8-sources', '2.7-sources', '2.8.1-sources'],
    },
    WCRxHWxoFi61NcxNv3SF0w: {
        filename: 'JndiManager.class',
        versions: ['2.12.1', '2.12.0'],
    },
    'xtIzvI6c/l2mkAWdJ9n4jw': {
        filename: 'log4j-core-2.8.jar',
        versions: ['2.8'],
    },
    zH1V7WnMX9NANbFcbt95oA: {
        filename: 'log4j-core-2.13.3.jar',
        versions: ['2.13.3'],
    },
    'EQqz4+TzeAkh6O5d3jNzrQ': {
        filename: 'log4j-core-2.3.jar',
        versions: ['2.3'],
    },
    'VSPxRPrvK/ygijyosr7Nag': {
        filename: 'log4j-core-2.6.jar',
        versions: ['2.6'],
    },
    'C1fpJhCjMxrxWn6Q+LNTnQ': {
        filename: 'Interpolator.class',
        versions: ['2.16.0'],
    },
    'QVwT58hQX7BW1UDqwpty+g': {
        filename: 'JndiManager.class',
        versions: ['2.7', '2.8.1', '2.8'],
    },
    zXChiI7N0xHBmQ54SGfOHg: {
        filename: 'log4j-core-2.0.jar',
        versions: ['2.0'],
    },
    'txoT/V3yUWlPyhFiQAA7Ig': {
        filename: 'log4j-core-2.13.0.jar',
        versions: ['2.13.0'],
    },
    VHuz7S3rhW0OO713wnuWJQ: {
        filename: 'log4j-core-2.8.1.jar',
        versions: ['2.8.1'],
    },
    SlF3oXJ2S9pvRHK5S6F8yw: {
        filename: 'log4j-core-2.8.2.jar',
        versions: ['2.8.2'],
    },
    ToAy4jACKoyI3X1SbwtnCw: {
        filename: 'JndiManager.java',
        versions: [
            '2.9.0-sources',
            '2.9.1-sources',
            '2.10.0-sources',
            '2.11.0-sources',
            '2.11.1-sources',
        ],
    },
    'oZNwOQSj8Y+zyQqHfrXIpw': {
        filename: 'JndiManager.class',
        versions: ['2.8.2'],
    },
    '+/pfM6tLKab91SRz7nuDTQ': {
        filename: 'log4j-core-2.0.1.jar',
        versions: ['2.0.1'],
    },
    'Kr7CzmZeDVKaPyj/+7st0w': {
        filename: 'log4j-core-2.11.0.jar',
        versions: ['2.11.0'],
    },
    'AHnJByMGWZaPD8DkGmq8+Q': {
        filename: 'log4j-core-2.4.jar',
        versions: ['2.4'],
    },
    '3o0BzBX9DHT+qLu2aOKJ9Q': {
        filename: 'log4j-core-2.0-rc2.jar',
        versions: ['2.0-rc2.jar'],
    },
    'siQt4Gd75lFdbO+/SOfl1Q': {
        filename: 'log4j-core-2.11.1.jar',
        versions: ['2.11.1'],
    },
    jTMVRLLnsgrRZt68olUNcw: {
        filename: 'log4j-core-2.1.jar',
        versions: ['2.1'],
    },
    '3Q4+C0BAg+xpYYqrtQuKwA': {
        filename: 'log4j-core-2.5.jar',
        versions: ['2.5'],
    },
    BP3XAYCdF0ZcF8fmA7GyAg: {
        filename: 'JndiManager.class',
        versions: ['2.11.1', '2.9.1', '2.11.0', '2.11.2', '2.10.0', '2.9.0'],
    },
    FS7LPOCUrFvJ6jnWEi4oFA: {
        filename: 'log4j-core-2.0-beta9.jar',
        versions: ['2.0-beta9.jar'],
    },
    'SPfzzaUwMKh+jDh9jR5CZQ': {
        filename: 'log4j-core-2.6.1.jar',
        versions: ['2.6.1'],
    },
    'axX0LDM6w5q6z+7rGIUqRA': {
        filename: 'JndiManager.class',
        versions: ['2.1', '2.2', '2.3'],
    },
    'XkvKXtILlKsZu2WDbak/lg': {
        filename: 'log4j-core-2.2.jar',
        versions: ['2.2'],
    },
    lI3aeHWTNAp68aGOMot7fw: {
        filename: 'log4j-core-2.14.1.jar',
        versions: ['2.14.1'],
    },
    'K2Pg5QY/2sz2aaHiY4Tz/Q': {
        filename: 'log4j-core-2.7.jar',
        versions: ['2.7'],
    },
    'iyJgsczmQUT2MQh2+UsWOA': {
        filename: 'JndiManager.class',
        versions: ['2.4', '2.4.1', '2.5'],
    },
    'CI3xE60kmrcr8Zt/ALhj1Q': {
        filename: 'log4j-core-2.0-rc1.jar',
        versions: ['2.0-rc1.jar'],
    },
    '3JkBHwR+Y9zHQbWraNEW2w': {
        filename: 'log4j-core-2.10.0.jar',
        versions: ['2.10.0'],
    },
    'XFJ4IdEISn7z4D1AFE/1Mg': {
        filename: 'log4j-core-2.12.0.jar',
        versions: ['2.12.0'],
    },
    n0GSikGCAN4iMt0yblIsxw: {
        filename: 'log4j-core-2.16.0.jar',
        versions: ['2.16.0'],
    },
    'XSU+U/qZPhIv8BIiGqSeww': {
        filename: 'JndiManager.class',
        versions: ['2.15.0'],
    },
    'NbG1m0kl+RbQmdW4+7nykQ': {
        filename: 'JndiManager.java',
        versions: [
            '2.11.2-sources',
            '2.12.1-sources',
            '2.13.0-sources',
            '2.13.1-sources',
            '2.13.2-sources',
            '2.14.1-sources',
            '2.12.0-sources',
            '2.13.3-sources',
            '2.14.0-sources',
        ],
    },
    'Kn94Du0/K5zJ8p4blmlGjw': {
        filename: 'JndiManager.java',
        versions: [
            '2.4-sources',
            '2.2-sources',
            '2.3-sources',
            '2.5-sources',
            '2.6.1-sources',
            '2.6.2-sources',
            '2.6-sources',
            '2.1-sources',
            '2.4.1-sources',
        ],
    },
    '02XkgiFBT5P+7wk6G/YH7w': {
        filename: 'log4j-core-2.13.1.jar',
        versions: ['2.13.1'],
    },
    '+rZGJX+UWwsqfOPhw+POXw': {
        filename: 'log4j-core-2.9.0.jar',
        versions: ['2.9.0'],
    },
    'lC9Cnqy4AV4Y2PWZls++5g': {
        filename: 'log4j-core-2.9.1.jar',
        versions: ['2.9.1'],
    },
    'yL2LXFqqoHo9y/V94BySZg': {
        filename: 'log4j-core-2.11.2.jar',
        versions: ['2.11.2'],
    },
    ATi6HBkdXHVP0OPDphwDBw: {
        filename: 'log4j-core-2.12.1.jar',
        versions: ['2.12.1'],
    },
    'hiwAsuhU+cDx6NhAnSPYmQ': {
        filename: 'log4j-core-2.14.0.jar',
        versions: ['2.14.0'],
    },
    'uhz4+B57MccJdoVhuoq1WA': {
        filename: 'JndiManager.class',
        versions: ['2.16.0'],
    },
    'O9n0G4nOT+jMv3PkMZWlzg': {
        filename: 'JndiManager.class',
        versions: ['2.6.1', '2.6', '2.6.2'],
    },
    '8dYwxIkoCWpITkuVzLFioA': {
        filename: 'JndiManager.class',
        versions: ['2.14.0', '2.14.1'],
    },
    jAzz6wRxVKT44W2vWiCTGQ: {
        filename: 'log4j-core-2.0.2.jar',
        versions: ['2.0.2'],
    },
};


/***/ }),

/***/ 86989:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const fs_1 = __webpack_require__(57147);
const crypto = __webpack_require__(6113);
const AdmZip = __webpack_require__(55285);
const ora = __webpack_require__(63395);
const semver = __webpack_require__(36625);
const log4shell_hashes_1 = __webpack_require__(60959);
const readFile = fs_1.promises.readFile;
const readDir = fs_1.promises.readdir;
const stat = fs_1.promises.stat;
const MAX_FILE_SIZE = 2 * 1024 * 1024 * 1024 - 1;
class Paths {
    constructor(paths) {
        this.paths = paths;
    }
    static empty() {
        return new Paths([]);
    }
    static fromZip(content, path) {
        try {
            const unzippedEntries = new AdmZip(content).getEntries();
            const entries = unzippedEntries.map((entry) => {
                return {
                    path: path + '/' + entry.entryName,
                    content: async () => entry.getData(),
                };
            });
            return new Paths(entries);
        }
        catch (error) {
            errors.push(error);
            return this.empty();
        }
    }
    static async fromDisk(paths) {
        try {
            const entries = paths.map((path) => {
                return {
                    path,
                    content: async () => await readFile(path),
                };
            });
            return new Paths(entries);
        }
        catch (error) {
            errors.push(error);
            return this.empty();
        }
    }
}
const errors = [];
async function startSpinner() {
    const spinner = ora({ isSilent: false, stream: process.stdout });
    spinner.text = `Looking for Log4Shell...`;
    spinner.start();
    return spinner;
}
// eslint-disable-next-line @typescript-eslint/no-unused-vars
async function log4shell(...args) {
    console.log('Please note this command is for already built artifacts. To test source code please use `snyk test`.');
    const signatures = new Array();
    const spinner = await startSpinner();
    const paths = await find('.');
    await parsePaths(await Paths.fromDisk(paths), signatures);
    spinner.stop();
    console.log('\nResults:');
    const issues = filterJndi(signatures);
    if (issues.length == 0) {
        console.log('No known vulnerable version of Log4J was detected');
        return;
    }
    const rceIssues = [];
    const dosIssues = [];
    issues.forEach((issue) => {
        issue.path = issue.path.replace(/(.*org\/apache\/logging\/log4j\/core).*/, '$1');
        if (issue.exploitType === 'Log4Shell') {
            rceIssues.push(issue);
        }
        if (issue.exploitType === 'DoS') {
            dosIssues.push(issue);
        }
    });
    if (rceIssues.length > 0) {
        displayIssues('A version of Log4J that is vulnerable to Log4Shell was detected:', rceIssues);
        displayRemediation('Log4Shell');
    }
    if (dosIssues.length > 0) {
        displayIssues('A version of Log4J that is vulnerable to CVE-2021-45105 (Denial of Service) was detected:', dosIssues);
        displayRemediation('DoS');
    }
    exitWithError();
}
exports["default"] = log4shell;
async function parsePaths(ctx, accumulator) {
    for (const { path, content } of ctx.paths) {
        if (!isArchiveOrJndi(path)) {
            continue;
        }
        const signature = await computeSignature(await content());
        const isVulnerable = signature in log4shell_hashes_1.vulnerableSignatures;
        if (isVulnerable || path.includes('JndiLookup')) {
            await append(path, signature, accumulator);
            continue;
        }
        if (!isVulnerable && isJavaArchive(path)) {
            await parsePaths(Paths.fromZip(await content(), path), accumulator);
        }
    }
}
async function computeSignature(content) {
    return crypto
        .createHash('md5')
        .update(content)
        .digest('base64')
        .replace(/=/g, '');
}
async function find(path) {
    const result = [];
    await traverse(path, (filePath, stats) => {
        if (!stats.isFile() || stats.size > MAX_FILE_SIZE) {
            return;
        }
        result.push(filePath);
    });
    return result;
}
async function traverse(path, handle) {
    try {
        const stats = await stat(path);
        if (!stats.isDirectory()) {
            handle(path, stats);
            return;
        }
        const entries = await readDir(path);
        for (const entry of entries) {
            const absolute = path + '/' + entry;
            await traverse(absolute, handle);
        }
    }
    catch (error) {
        errors.push(error);
    }
}
async function computeExploitType(signatureDetails) {
    for (const version of signatureDetails.versions) {
        const coercedVersion = semver.coerce(version);
        if (coercedVersion === null) {
            continue;
        }
        if (semver.lt(coercedVersion, '2.16.0')) {
            return 'Log4Shell';
        }
        if (semver.satisfies(coercedVersion, '2.16.x')) {
            return 'DoS';
        }
    }
    return 'Unknown';
}
function displayIssues(message, signatures) {
    console.log(message);
    signatures.forEach((signature) => {
        console.log(`\t${signature.path}`);
    });
}
function displayRemediation(exploitType) {
    switch (exploitType) {
        case 'Log4Shell':
            console.log(`\nWe highly recommend fixing this vulnerability. If it cannot be fixed by upgrading, see mitigation information here:
      \t- https://security.snyk.io/vuln/SNYK-JAVA-ORGAPACHELOGGINGLOG4J-2314720
      \t- https://snyk.io/blog/log4shell-remediation-cheat-sheet/\n`);
            break;
        case 'DoS':
            console.log(`\nWe recommend fixing this vulnerability by upgrading to a later version. To learn more about this vulnerability, see:
      \t- https://security.snyk.io/vuln/SNYK-JAVA-ORGAPACHELOGGINGLOG4J-2321524\n`);
            break;
        default:
            break;
    }
}
function isJavaArchive(path) {
    return path.endsWith('.jar') || path.endsWith('.war') || path.endsWith('ear');
}
function isArchiveOrJndi(path) {
    return (isJavaArchive(path) ||
        path.includes('JndiManager') ||
        path.includes('JndiLookup'));
}
async function append(path, signature, accumulator) {
    const exploitType = log4shell_hashes_1.vulnerableSignatures[signature]
        ? await computeExploitType(log4shell_hashes_1.vulnerableSignatures[signature])
        : 'Unknown';
    accumulator.push({
        value: signature,
        path,
        exploitType,
    });
}
function filterJndi(signatures) {
    return signatures.filter((signature) => {
        if (isJavaArchive(signature.path)) {
            return true;
        }
        if (signature.path.includes('JndiManager')) {
            const jndiManagerPathIndex = signature.path.indexOf('/net/JndiManager.class');
            const jndiLookupPath = signature.path.substr(0, jndiManagerPathIndex) + '/lookup/JndiLookup';
            const isJndiLookupPresent = signatures.find((element) => element.path.includes(jndiLookupPath));
            return !!isJndiLookupPresent;
        }
        return false;
    });
}
function exitWithError() {
    const err = new Error();
    err.code = 'VULNS';
    throw err;
}


/***/ })

};
;
//# sourceMappingURL=989.index.js.map