class BlockListModel {
  final List<BlockList>? data;
  final int? responseCode;
  final String? responseMsg;
  final String? result;
  final String? serverTime;

  BlockListModel({
    this.data,
    this.responseCode,
    this.responseMsg,
    this.result,
    this.serverTime,
  });

  BlockListModel.fromJson(Map<String, dynamic> json)
      : data = (json['data'] as List?)?.map((dynamic e) => BlockList.fromJson(e as Map<String, dynamic>)).toList(),
        responseCode = json['ResponseCode'] as int?,
        responseMsg = json['ResponseMsg'] as String?,
        result = json['Result'] as String?,
        serverTime = json['ServerTime'] as String?;

  Map<String, dynamic> toJson() =>
      {'data': data?.map((e) => e.toJson()).toList(), 'ResponseCode': responseCode, 'ResponseMsg': responseMsg, 'Result': result, 'ServerTime': serverTime};
}

class BlockList {
  final int? userId;
  final String? fname;
  final String? uniqueId;

  BlockList({
    this.userId,
    this.fname,
    this.uniqueId,
  });

  BlockList.fromJson(Map<String, dynamic> json)
      : userId = json['user_id'] as int?,
        fname = json['fname'] as String?,
        uniqueId = json['unique_id'] as String?;

  Map<String, dynamic> toJson() => {'user_id': userId, 'fname': fname, 'unique_id': uniqueId};
}
