import 'package:voice_buddies/app/utils/all_imports.dart';

class LoginDataModel {
  final LoginData? data;
  final int? responseCode;
  final String? responseMsg;
  final String? result;
  final String? serverTime;
  final int? otp;

  LoginDataModel({
    this.data,
    this.responseCode,
    this.responseMsg,
    this.result,
    this.serverTime,
    this.otp,
  });

  LoginDataModel.fromJson(Map<String, dynamic> json)
      : data = (json['data'] as Map<String, dynamic>?) != null ? LoginData.fromJson(json['data'] as Map<String, dynamic>) : null,
        responseCode = json['ResponseCode'] as int?,
        responseMsg = json['ResponseMsg'] as String?,
        result = json['Result'] as String?,
        otp = json['otp'] as int?,
        serverTime = json['ServerTime'] as String?;

  Map<String, dynamic> toJson() => {'data': data?.toJson(), 'ResponseCode': responseCode, 'ResponseMsg': responseMsg, 'Result': result, 'ServerTime': serverTime, 'otp': otp};
}

class LoginData {
  final int? userId;
  final int? isBlock;
  final String? fname;
  final String? email;
  final String? gender;
  final String? age;
  final String? iAm;
  final String? iLive;
  final String? spoken;
  final String? voice;
  final String? uniqueId;
  final String? name;
  final String? media;
  final String? token;
  final String? ccode;
  final String? phone;
  final List<FlagNotifies>? flagNotifies;

  LoginData({
    this.userId,
    this.isBlock,
    this.fname,
    this.email,
    this.gender,
    this.age,
    this.iAm,
    this.iLive,
    this.spoken,
    this.voice,
    this.uniqueId,
    this.name,
    this.media,
    this.ccode,
    this.phone,
    this.token,
    this.flagNotifies,
  });

  LoginData.fromJson(Map<String, dynamic> json)
      : flagNotifies = (json['flag_notifies'] as List?)?.map((dynamic e) => FlagNotifies.fromJson(e as Map<String, dynamic>)).toList(),
        userId = json['user_id'] as int?,
        isBlock = json['is_block'] as int?,
        fname = json['fname'] as String?,
        email = json['email'] as String?,
        gender = json['gender'].toString().capitalizeFirst,
        age = json['age'] as String?,
        iAm = json['i_am'] as String?,
        ccode = json['ccode'] as String?,
        phone = json['phone'] as String?,
        iLive = json['i_live'] as String?,
        spoken = json['spoken'] as String?,
        voice = json['voice'] as String?,
        uniqueId = json['unique_id'] as String?,
        name = json['name'] as String?,
        media = json['media'] as String?,
        token = json['token'] as String?;

  Map<String, dynamic> toJson() => {'user_id': userId, 'flag_notifies': flagNotifies?.map((e) => e.toJson()).toList(), 'is_block': isBlock, 'fname': fname, 'email': email, 'gender': gender, 'age': age, 'i_am': iAm, 'i_live': iLive, 'spoken': spoken, 'voice': voice, 'unique_id': uniqueId, 'name': name, 'media': media, 'ccode': ccode, 'phone': phone, 'token': token};
}

class FlagNotifies {
  final String? notifyMsg;
  final int? mfId;

  FlagNotifies({
    this.notifyMsg,
    this.mfId,
  });

  FlagNotifies.fromJson(Map<String, dynamic> json)
      : notifyMsg = json['notify_msg'] as String?,
        mfId = json['mf_id'] as int?;

  Map<String, dynamic> toJson() => {'notify_msg': notifyMsg, 'mf_id': mfId};
}
