class MessageModel {
  final List<MessageData>? resData;

  MessageModel({
    this.resData,
  });

  MessageModel.fromJson(Map<String, dynamic> json) : resData = (json['resData'] as List?)?.map((dynamic e) => MessageData.fromJson(e as Map<String, dynamic>)).toList();

  Map<String, dynamic> toJson() => {'resData': resData?.map((e) => e.toJson()).toList()};
}

class MessageData {
  final String? msgId;
  final String? msg;
  final String? senderId;
  final String? receiverId;
  final String? msgType;
  final String? createdAt;
  final String? userId;
  final String? fname;
  final String? uniqueId;
  String? unreadCount;
  final int? otherId;
  final String? profile;
  final int? isDelete;

  MessageData({
    this.msgId,
    this.msg,
    this.senderId,
    this.receiverId,
    this.msgType,
    this.createdAt,
    this.isDelete,
    this.userId,
    this.fname,
    this.uniqueId,
    this.unreadCount,
    this.otherId,
    this.profile,
  });

  MessageData.fromJson(Map<String, dynamic> json)
      : msgId = json['msg_id'] as String?,
        msg = json['msg'] as String?,
        senderId = json['sender_id'] as String?,
        receiverId = json['receiver_id'] as String?,
        msgType = json['msg_type'] as String?,
        isDelete = json['is_delete'] as int?,
        createdAt = json['created_at'] as String?,
        userId = json['user_id'] as String?,
        fname = json['fname'] as String?,
        uniqueId = json['unique_id'] as String?,
        unreadCount = json['unread_count'] as String?,
        otherId = json['other_id'] as int?,
        profile = json['profile'] as String?;

  Map<String, dynamic> toJson() => {'msg_id': msgId, 'msg': msg, 'sender_id': senderId, 'receiver_id': receiverId, 'msg_type': msgType, 'created_at': createdAt, 'user_id': userId, 'fname': fname, 'unique_id': uniqueId, 'unread_count': unreadCount, 'other_id': otherId, 'profile': profile};
}
