class SearchModel {
  final List<SearchResult>? data;
  final int? responseCode;
  final String? responseMsg;
  final String? result;
  final String? serverTime;

  SearchModel({
    this.data,
    this.responseCode,
    this.responseMsg,
    this.result,
    this.serverTime,
  });

  SearchModel.fromJson(Map<String, dynamic> json)
      : data = (json['data'] as List?)?.map((dynamic e) => SearchResult.fromJson(e as Map<String, dynamic>)).toList(),
        responseCode = json['ResponseCode'] as int?,
        responseMsg = json['ResponseMsg'] as String?,
        result = json['Result'] as String?,
        serverTime = json['ServerTime'] as String?;

  Map<String, dynamic> toJson() =>
      {'data': data?.map((e) => e.toJson()).toList(), 'ResponseCode': responseCode, 'ResponseMsg': responseMsg, 'Result': result, 'ServerTime': serverTime};
}

class SearchResult {
  final int? userId;
  final String? fname;
  final String? email;
  final String? gender;
  final String? age;
  final String? iAm;
  final String? iLive;
  final String? spoken;
  final String? voice;
  final String? uniqueId;

  SearchResult({
    this.userId,
    this.fname,
    this.email,
    this.gender,
    this.age,
    this.iAm,
    this.iLive,
    this.spoken,
    this.voice,
    this.uniqueId,
  });

  SearchResult.fromJson(Map<String, dynamic> json)
      : userId = json['user_id'] as int?,
        fname = json['fname'] as String?,
        email = json['email'] as String?,
        gender = json['gender'] as String?,
        age = json['age'] as String?,
        iAm = json['i_am'] as String?,
        iLive = json['i_live'] as String?,
        spoken = json['spoken'] as String?,
        voice = json['voice'] as String?,
        uniqueId = json['unique_id'] as String?;

  Map<String, dynamic> toJson() => {
        'user_id': userId,
        'fname': fname,
        'email': email,
        'gender': gender,
        'age': age,
        'i_am': iAm,
        'i_live': iLive,
        'spoken': spoken,
        'voice': voice,
        'unique_id': uniqueId
      };
}
