import 'package:voice_buddies/app/modules/home/views/home_view.dart';
import 'package:voice_buddies/app/modules/search/views/search_view.dart';
import 'package:voice_buddies/app/modules/settings/views/settings_view.dart';
import 'package:voice_buddies/app/modules/vb/views/vb_view.dart';

import '../../../utils/all_imports.dart';
import '../controllers/bottom_bar_controller.dart';

class BottomBarView extends GetView<BottomBarController> {
  const BottomBarView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<BottomBarController>(
      init: BottomBarController(),
      assignId: true,
      builder: (controller) {
        return Obx(() {
          return Scaffold(
              backgroundColor: AppColors.transparent,
              bottomNavigationBar: Container(
                height: 62.h + MediaQuery.of(context).padding.bottom,
                padding: EdgeInsets.zero,
                decoration: const BoxDecoration(
                  color: AppColors.greyText,
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    GestureDetector(
                      onTap: () {
                        controller.currentIndex.value = 0;
                      },
                      child: Container(
                        color: AppColors.transparent,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Container(
                              height: 2.h,
                              width: 90.w,
                              decoration: BoxDecoration(
                                gradient: LinearGradient(
                                  colors: controller.currentIndex.value == 0
                                      ? [
                                          AppColors.greenGradient1,
                                          AppColors.greenGradient2,
                                          AppColors.greenGradient3,
                                        ]
                                      : [AppColors.transparent, AppColors.transparent],
                                ),
                              ),
                            ),
                            SizedBox(height: 10.h),
                            Image.asset(
                              AppImages.icInbox,
                              color: controller.currentIndex.value == 0 ? AppColors.greenGradient2 : AppColors.darkBlue600,
                              height: 24.h,
                              width: 24.w,
                            ),
                            SizedBox(height: 2.h),
                            GradientAppText(
                              AppStrings.inbox,
                              gradientColor: controller.currentIndex.value == 0
                                  ? [
                                      AppColors.greenGradient1,
                                      AppColors.greenGradient2,
                                      AppColors.greenGradient3,
                                    ]
                                  : [
                                      AppColors.darkBlue600,
                                      AppColors.darkBlue600,
                                    ],
                              color: AppColors.darkBlue600,
                              textAlign: TextAlign.center,
                              fontWeight: controller.currentIndex.value == 0 ? FontWeight.w600 : FontWeight.w400,
                              fontSize: 12.sp,
                            ),
                          ],
                        ),
                      ),
                    ),
                    GestureDetector(
                      onTap: () {
                        controller.currentIndex.value = 1;
                      },
                      child: Container(
                        color: AppColors.transparent,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Container(
                              height: 2.h,
                              width: 90.w,
                              decoration: BoxDecoration(
                                gradient: LinearGradient(
                                  colors: controller.currentIndex.value == 1
                                      ? [
                                          AppColors.greenGradient1,
                                          AppColors.greenGradient2,
                                          AppColors.greenGradient3,
                                        ]
                                      : [AppColors.transparent, AppColors.transparent],
                                ),
                              ),
                            ),
                            SizedBox(height: 10.h),
                            Image.asset(
                              AppImages.icSearch,
                              height: 24.h,
                              width: 24.w,
                              color: controller.currentIndex.value == 1 ? AppColors.greenGradient2 : AppColors.darkBlue600,
                            ),
                            SizedBox(height: 2.h),
                            GradientAppText(
                              AppStrings.search,
                              color: AppColors.darkBlue600,
                              textAlign: TextAlign.center,
                              fontWeight: controller.currentIndex.value == 1 ? FontWeight.w600 : FontWeight.w400,
                              fontSize: 12.sp,
                              gradientColor: controller.currentIndex.value == 1
                                  ? [
                                      AppColors.greenGradient1,
                                      AppColors.greenGradient2,
                                      AppColors.greenGradient3,
                                    ]
                                  : [
                                      AppColors.darkBlue600,
                                      AppColors.darkBlue600,
                                    ],
                            ),
                          ],
                        ),
                      ),
                    ),
                    GestureDetector(
                      onTap: () {
                        controller.currentIndex.value = 2;
                      },
                      child: Container(
                        color: AppColors.transparent,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Container(
                              height: 2.h,
                              width: 90.w,
                              decoration: BoxDecoration(
                                gradient: LinearGradient(
                                  colors: controller.currentIndex.value == 2
                                      ? [
                                          AppColors.greenGradient1,
                                          AppColors.greenGradient2,
                                          AppColors.greenGradient3,
                                        ]
                                      : [AppColors.transparent, AppColors.transparent],
                                ),
                              ),
                            ),
                            SizedBox(height: 10.h),
                            Image.asset(
                              AppImages.icSetting,
                              height: 24.h,
                              width: 24.w,
                              color: controller.currentIndex.value == 2 ? AppColors.greenGradient2 : AppColors.darkBlue600,
                            ),
                            SizedBox(height: 2.h),
                            GradientAppText(
                              AppStrings.settings,
                              color: AppColors.darkBlue600,
                              textAlign: TextAlign.center,
                              fontWeight: controller.currentIndex.value == 2 ? FontWeight.w600 : FontWeight.w400,
                              fontSize: 12.sp,
                              gradientColor: controller.currentIndex.value == 2
                                  ? [
                                      AppColors.greenGradient1,
                                      AppColors.greenGradient2,
                                      AppColors.greenGradient3,
                                    ]
                                  : [
                                      AppColors.darkBlue600,
                                      AppColors.darkBlue600,
                                    ],
                            ),
                          ],
                        ),
                      ),
                    ),
                    GestureDetector(
                      onTap: () {
                        controller.currentIndex.value = 3;
                      },
                      child: Container(
                        color: AppColors.transparent,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Container(
                              height: 2.h,
                              width: 90.w,
                              decoration: BoxDecoration(
                                gradient: LinearGradient(
                                  colors: controller.currentIndex.value == 3
                                      ? [
                                          AppColors.greenGradient1,
                                          AppColors.greenGradient2,
                                          AppColors.greenGradient3,
                                        ]
                                      : [AppColors.transparent, AppColors.transparent],
                                ),
                              ),
                            ),
                            SizedBox(height: 10.h),
                            Image.asset(
                              AppImages.icVb,
                              height: 24.h,
                              width: 24.w,
                              color: controller.currentIndex.value == 3 ? AppColors.greenGradient2 : AppColors.darkBlue600,
                            ),
                            SizedBox(height: 2.h),
                            GradientAppText(
                              AppStrings.vb,
                              color: AppColors.darkBlue600,
                              textAlign: TextAlign.center,
                              fontWeight: controller.currentIndex.value == 3 ? FontWeight.w600 : FontWeight.w400,
                              fontSize: 12.sp,
                              gradientColor: controller.currentIndex.value == 3
                                  ? [
                                      AppColors.greenGradient1,
                                      AppColors.greenGradient2,
                                      AppColors.greenGradient3,
                                    ]
                                  : [
                                      AppColors.darkBlue600,
                                      AppColors.darkBlue600,
                                    ],
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
              ),
              body: IndexedStack(
                index: controller.currentIndex.value,
                children: const [
                  HomeView(),
                  SearchView(),
                  SettingsView(),
                  VbView(),
                ],
              ));
        });
      },
    );
  }
}
