import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_textfiled.dart';

import '../../../utils/all_imports.dart';
import '../controllers/change_password_controller.dart';

class ChangePasswordView extends GetView<ChangePasswordController> {
  const ChangePasswordView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ChangePasswordController>(
      init: ChangePasswordController(),
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: AppStrings.changePassword,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              padding: EdgeInsets.zero,
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 15.h),
                CommonTextFiled(
                  title: AppStrings.currentPassword,
                  prefixIcon: AppImages.icLock,
                  controller: controller.currentPassword,
                  hintText: AppStrings.enterCurrentPassword,
                  suffixVisibility: true,
                  isMaxLines: true,
                  obscureText: false,
                  maxLines: 1,
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.newPassword,
                  prefixIcon: AppImages.icLock,
                  controller: controller.newPassword,
                  hintText: AppStrings.enterNewPassword,
                  suffixVisibility: true,
                  isMaxLines: true,
                  enableInteractiveSelection: false,
                  obscureText: false,
                  maxLines: 1,
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.confirmNewPassword,
                  prefixIcon: AppImages.icLock,
                  controller: controller.confirmPassword,
                  hintText: AppStrings.enterConfirmNewPassword,
                  suffixVisibility: true,
                  enableInteractiveSelection: false,
                  isMaxLines: true,
                  obscureText: false,
                  maxLines: 1,
                  textInputAction: TextInputAction.done,
                ),
                SizedBox(
                  height: 30.h,
                ),
                CommonButton(
                  buttonTitle: AppStrings.update,
                  onTap: () {
                    utils.hideKeyboard(context);
                    if (controller.isValidation()) {
                      controller.changePasswordApi();
                    }
                  },
                ),
                SizedBox(height: 25.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
