import 'package:voice_buddies/app/widget/base_controller.dart';

import '../../../models/login_model.dart';
import '../../../utils/all_imports.dart';

class ContactUsController extends BaseController {
  TextEditingController name = TextEditingController();
  TextEditingController email = TextEditingController();
  TextEditingController subject = TextEditingController();
  TextEditingController message = TextEditingController();
  @override
  void onInit() {
    getUserData();
    name.text = loginData!.fname!;
    email.text = loginData!.email!;
    super.onInit();
  }

  ///  contactUsApi
  contactUsApi() async {
    FormData formData = FormData.fromMap({
      "name": name.text,
      "email": email.text,
      "subject": subject.text,
      "message": message.text,
    });
    final data = await APIFunction().apiCall(
      apiName: Constants.contactUs,
      params: formData,
      token: loginData?.token,
    );
    LoginDataModel model = LoginDataModel.fromJson(data);
    if (model.responseCode == 1) {
      name.clear();
      email.clear();
      subject.clear();
      message.clear();
      Get.toNamed(Routes.DONE, arguments: AppStrings.contactUs);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }

  /// validation
  bool isValidation() {
    if (utils.isValidationEmpty(name.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageName);
      return false;
    } else if (utils.isValidationEmpty(email.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageEmail);
      return false;
    } else if (!utils.emailValidator(email.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageValidEmail);
      return false;
    } else if (utils.isValidationEmpty(subject.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageSubject);
      return false;
    } else if (utils.isValidationEmpty(message.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageMessage);
      return false;
    }

    return true;
  }
}
