import 'package:flutter/foundation.dart';
import 'package:voice_buddies/app/models/login_model.dart';
import 'package:voice_buddies/app/widget/base_controller.dart';

import '../../../utils/all_imports.dart';

class CreateNewPasswordController extends BaseController {
  TextEditingController newPassword = TextEditingController(text: (kDebugMode) ? "Bhumit@123" : "");
  TextEditingController confirmPassword = TextEditingController(text: (kDebugMode) ? "Bhumit@123" : "");
  RxString email = "".obs;

  @override
  void onInit() {
    if (Get.arguments != null) {
      email.value = Get.arguments[0];
    }
    super.onInit();
  }

  /// validation
  bool isValidation() {
    if (utils.isValidationEmpty(newPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageNewPassword);
      return false;
    } else if (!utils.passwordValidator(newPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageNewValidPassword);
      return false;
    } else if (utils.isValidationEmpty(confirmPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageConfirmPassword);
      return false;
    } else if (newPassword.text.trim() != confirmPassword.text.trim()) {
      utils.showSnackBar(message: AppStrings.errorMessageNotMatchPass);
      return false;
    }

    return true;
  }

  /// Create New Password Api
  updatePasswordApi() async {
    FormData formData = FormData.fromMap({
      "email": email.value,
      "password": utils.generateMd5(confirmPassword.text),
    });
    final data = await APIFunction().apiCall(
      apiName: Constants.updatePassword,
      params: formData,
    );

    LoginDataModel model = LoginDataModel.fromJson(data);

    if (model.responseCode == 1) {
      email.value = "";
      newPassword.clear();
      confirmPassword.clear();
      Get.toNamed(Routes.DONE, arguments: "done");
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
