import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_container.dart';
import 'package:voice_buddies/app/widget/common_textfiled.dart';

import '../../../utils/all_imports.dart';
import '../controllers/delete_account_controller.dart';

class DeleteAccountView extends GetView<DeleteAccountController> {
  const DeleteAccountView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<DeleteAccountController>(
      init: DeleteAccountController(),
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          onTap: () {
            utils.hideKeyboard(Get.context!);
            /*if (controller.isOtherReason.value) {
              controller.isOtherReason.value = false;
              controller.message.clear();
              controller.update();
            } else {*/
            Get.back();
            // }
          },
          title: AppStrings.reason,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 10.h),
                ListView.builder(
                  padding: EdgeInsets.zero,
                  physics: NeverScrollableScrollPhysics(),
                  shrinkWrap: true,
                  itemCount: controller.deleteReason.length,
                  itemBuilder: (context, index) {
                    return commonSelect(
                      controller: controller,
                      index: index,
                      list: controller.deleteReason,
                    );
                  },
                ),
                if (controller.deleteReason.last.isSelected) SizedBox(height: 10.h),
                if (controller.deleteReason.last.isSelected)
                  Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                    AppText(
                      AppStrings.message,
                      color: AppColors.darkBlueText,
                      textAlign: TextAlign.start,
                      fontWeight: FontWeight.w600,
                      fontSize: 16.sp,
                    ),
                    SizedBox(height: 10.h),
                    CommonContainer(
                      color: AppColors.greyText,
                      padding: EdgeInsets.only(right: 10.w),
                      isHeight: false,
                      borderRadius: 10.r,
                      isBorderRadius: true,
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Padding(
                            padding: EdgeInsets.only(left: 15.w, right: 10.w, top: 23.h),
                            child: Image.asset(
                              AppImages.icMessage,
                              height: 24.h,
                              width: 24.w,
                            ),
                          ),
                          Expanded(
                            child: CommonMultiLineTextFiled(
                              controller: controller.message,
                              hintText: AppStrings.imLeavingDoNotPayBecause,
                              maxLines: 6,
                              textInputAction: TextInputAction.done,
                              isMaxLines: true,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ]),
                SizedBox(height: 30.h),
                CommonButton(
                    buttonTitle: controller.deleteReason.last.isSelected ? AppStrings.deleteMyAccount : AppStrings.done,
                    onTap: () {
                      controller.selectedReason.value = controller.getSelectedReasonName();

                      if (controller.deleteReason.last.isSelected) {
                        if (utils.isValidationEmpty(controller.message.text)) {
                          utils.showToast(message: AppStrings.pleaseEnterOtherReason);
                        } else {
                          Get.toNamed(Routes.DELETE_LOGOUT_CONFIRMATION, arguments: [AppStrings.delete, controller.message.text]);
                        }
                      } else {
                        if (controller.selectedReason.value.isEmpty) {
                          utils.showToast(message: AppStrings.pleaseEnterDeleteReason);
                        } else {
                          Get.toNamed(Routes.DELETE_LOGOUT_CONFIRMATION, arguments: [AppStrings.delete, controller.selectedReason.value]);
                        }
                      }
                    }),
                SizedBox(height: 30.h),
              ],
            ),
          ),
        );
      },
    );
  }

  Widget commonSelect({DeleteAccountController? controller, int? index, List? list}) {
    return Padding(
      padding: EdgeInsets.only(bottom: 18.h),
      child: GestureDetector(
        onTap: () {
          controller?.selectedIndex = index!;
          printAction("${controller?.selectedIndex}==$index");
          list?.any((element) {
            if (element.isSelected == true) {
              element.isSelected = false;
            }
            return false;
          });
          list?[index!].isSelected = !list[index].isSelected;
          list?.any((element) {
            if (element.isSelected) {
              controller?.selectedReason.value = element.name;
              return true;
            }
            return false;
          });
          controller?.update();
        },
        child: Container(
          width: double.infinity,
          padding: EdgeInsets.symmetric(vertical: 15.h, horizontal: 15.w),
          decoration: BoxDecoration(color: AppColors.greyText, borderRadius: BorderRadius.circular(10.r)),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              list?[index!].isSelected
                  ? GradientAppText(
                      list?[index!].name,
                      textAlign: TextAlign.center,
                      fontWeight: FontWeight.w600,
                      fontSize: 16.sp,
                    )
                  : AppText(
                      list?[index!].name,
                      textAlign: TextAlign.center,
                      color: AppColors.darkBlue700,
                      fontWeight: FontWeight.w400,
                      fontSize: 16.sp,
                    ),
              Image.asset(
                list?[index!].isSelected ? AppImages.icCheckOn : AppImages.icCheckOff,
                width: 24.w,
                height: 24.h,
              )
            ],
          ),
        ),
      ),
    );
  }
}
