import 'package:voice_buddies/app/widget/common_button.dart';

import '../../../utils/all_imports.dart';
import '../controllers/done_controller.dart';

class DoneView extends GetView<DoneController> {
  const DoneView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<DoneController>(
      init: DoneController(),
      builder: (controller) {
        return CommonScreen(
          isAppBar: false,
          isSafeArea: false,
          isLeading: true,
          child: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                SizedBox(height: 25.h),
                Image.asset(
                  controller.argument.value == "done" || controller.argument.value == AppStrings.congratulations || controller.argument.value == AppStrings.contactUs
                      ? AppImages.icCheckImg
                      : controller.argument.value == AppStrings.changePassword
                          ? AppImages.icPassImg
                          : controller.argument.value == AppStrings.editProfile
                              ? AppImages.icProfileImg
                              : AppImages.icLockImg,
                  width: 130.w,
                  height: 130.w,
                ),
                SizedBox(height: 20.h),
                GradientAppText(
                  controller.argument.value == "done"
                      ? AppStrings.allDone
                      : controller.argument.value == AppStrings.contactUs
                          ? AppStrings.requestSent
                          : controller.argument.value == AppStrings.changePassword
                              ? AppStrings.passwordChanged
                              : controller.argument.value == AppStrings.editProfile
                                  ? AppStrings.profileUpdated
                                  : AppStrings.congratulations,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 26.sp,
                ),
                SizedBox(height: 10.h),
                AppText(
                  controller.argument.value == "done"
                      ? AppStrings.yourPasswordHasReset
                      : controller.argument.value == AppStrings.contactUs
                          ? AppStrings.youHaveSuccessfullySentYourContactUsRequest
                          : controller.argument.value == AppStrings.changePassword
                              ? AppStrings.passwordChangedSuccessfully
                              : controller.argument.value == AppStrings.editProfile
                                  ? AppStrings.youHaveProfileUpdated
                                  : AppStrings.yourAccountSuccessFully,
                  color: AppColors.darkBlue700,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.w500,
                  height: 1.40.h,
                  fontSize: 18.sp,
                ),
                SizedBox(height: 30.h),
                CommonButton(
                  buttonTitle: AppStrings.ok,
                  onTap: () {
                    controller.argument.value == "done"
                        ? Get.until((route) => route.settings.name == Routes.LOGIN)
                        : controller.argument.value == AppStrings.contactUs
                            ? Get.until((route) => route.settings.name == Routes.BOTTOM_BAR)
                            : controller.argument.value == AppStrings.changePassword
                                ? Get.until((route) => route.settings.name == Routes.EDIT_PROFILE)
                                : controller.argument.value == AppStrings.editProfile
                                    ? Get.until((route) => route.settings.name == Routes.BOTTOM_BAR)
                                    : Get.offAllNamed(Routes.GET_STARTED);
                  },
                ),
                SizedBox(height: 25.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
