import '../../../utils/all_imports.dart';
import '../../../widget/common_button.dart';
import '../controllers/done_signup_controller.dart';

class DoneSignupView extends GetView<DoneSignupController> {
  const DoneSignupView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<DoneSignupController>(
      init: DoneSignupController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: false,
          isSafeArea: false,
          isLeading: true,
          child: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 200.h),
                Image.asset(
                  AppImages.icCheckImg,
                  width: 130.w,
                  height: 130.w,
                ),
                SizedBox(height: 20.h),
                GradientAppText(
                  AppStrings.congratulations,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 26.sp,
                ),
                SizedBox(height: 10.h),
                AppText(
                  AppStrings.yourAccountSuccessFully2,
                  color: AppColors.darkBlue700,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.w500,
                  height: 1.40.h,
                  fontSize: 18.sp,
                ),
                SizedBox(
                  height: 30.h,
                ),
                CommonButton(
                  buttonTitle: AppStrings.ok,
                  onTap: () {
                    // Get.offAllNamed(Routes.GET_STARTED, arguments: [controller.email.value, controller.password.value]);

                    Get.offAllNamed(Routes.LOGIN);
                  },
                ),
                SizedBox(height: 25.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
