import 'package:voice_buddies/app/models/login_model.dart';

import '../../../utils/all_imports.dart';

class GetStartedController extends GetxController {
  RxString email = "".obs;
  RxString password = "".obs;
  @override
  void onInit() {
    if (Get.arguments != null) {
      email.value = Get.arguments[0];
      password.value = Get.arguments[1];

      super.onInit();
    }
  }

  /// Login Api
  loginApi() async {
    FormData formData = FormData.fromMap({
      "email": email.value,
      "password": password.value,
    });

    final data = await APIFunction().apiCall(
      apiName: Constants.login,
      params: formData,
    );

    LoginDataModel model = LoginDataModel.fromJson(data);

    if (model.responseCode == 1) {
      await getStorageData.saveObject(getStorageData.loginData, model.data!);
      email.value = "";
      password.value = "";
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
