import 'package:voice_buddies/app/widget/common_button.dart';

import '../../../utils/all_imports.dart';
import '../controllers/get_started_controller.dart';

class GetStartedView extends GetView<GetStartedController> {
  const GetStartedView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<GetStartedController>(
      init: GetStartedController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isBackButton: false,
          prefSize: 0,
          isSafeArea: false,
          isLeading: true,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 60.h),
                Image.asset(
                  AppImages.icStartImg,
                  width: 340.w,
                  height: 406.w,
                ),
                SizedBox(height: 60.h),
                GradientAppText(
                  "lorem ipsum",
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 26.sp,
                ),
                SizedBox(height: 10.h),
                AppText(
                  "Lorem Ipsum is simply dummy text\nof the printing industry.",
                  color: AppColors.darkBlue700,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.w500,
                  fontSize: 18.sp,
                ),
                SizedBox(
                  height: 35.h,
                ),
                CommonButton(
                  buttonTitle: AppStrings.getStarted,
                  onTap: () {
                    Get.offAllNamed(Routes.BOTTOM_BAR);
                    // controller.loginApi();
                  },
                ),
                SizedBox(height: 25.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
