import '../../../helper/iphone_has_notch.dart';
import '../../../utils/all_imports.dart';
import '../../../widget/common_button.dart';
import '../../../widget/common_textfiled.dart';
import '../controllers/login_controller.dart';

class LoginView extends GetView<LoginController> {
  const LoginView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<LoginController>(
      init: LoginController(),
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isBackButton: false,
          prefSize: 0.h,
          isBottomBar: true,
          bottomBar: Padding(
            padding: EdgeInsets.only(bottom: (IphoneHasNotch.hasNotch) ? 25.h : 20.h),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                AppText(
                  AppStrings.doesNotHaveAnAccount,
                  color: AppColors.darkBlue400,
                  fontWeight: FontWeight.w500,
                  fontSize: 16.sp,
                ),
                const Text(" "),
                GestureDetector(
                  onTap: () {
                    Get.toNamed(Routes.SIGNUP);
                  },
                  child: GradientAppText(
                    AppStrings.signup,
                    fontWeight: FontWeight.w600,
                    fontSize: 16.sp,
                  ),
                )
              ],
            ),
          ),
          isSafeArea: false,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              children: [
                Padding(
                  padding: EdgeInsets.only(right: 40.w, top: 60.h),
                  child: Image.asset(
                    AppImages.appLogo,
                    width: 182.w,
                    height: 100.w,
                  ),
                ),
                // GradientAppText(
                //   AppStrings.welcomeBack,
                //   textAlign: TextAlign.center,
                //   fontWeight: FontWeight.bold,
                //   fontSize: 26.sp,
                //   isGreenGradient: false,
                // ),
                SizedBox(height: 40.h),
                CommonTextFiled(
                  title: AppStrings.emailPhoneNumber,
                  controller: controller.email,
                  hintText: AppStrings.enterEmailPhoneNumber,
                  prefixIcon: AppImages.email,
                  inputType: TextInputType.emailAddress,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp("[A-Z]")),
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.password,
                  controller: controller.passwordController,
                  hintText: AppStrings.enterPassword,
                  suffixVisibility: true,
                  isMaxLines: true,
                  maxLines: 1,
                  prefixIcon: AppImages.password,
                  obscureText: false,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                  textInputAction: TextInputAction.done,
                ),
                SizedBox(height: 30.h),
                GestureDetector(
                  onTap: () {
                    controller.email.clear();
                    controller.passwordController.clear();
                    Get.toNamed(Routes.FORGOT_PASSWORD);
                  },
                  child: AppText(
                    AppStrings.forgetPassword,
                    textAlign: TextAlign.center,
                    color: AppColors.darkBlueText,
                    fontWeight: FontWeight.w600,
                    fontSize: 16.sp,
                  ),
                ),
                SizedBox(height: 30.h),
                CommonButton(
                  buttonTitle: AppStrings.signIn,
                  onTap: () {
                    if (controller.isValidation()) {
                      controller.loginApi();
                    }
                  },
                ),
                SizedBox(height: 50.h),
                AppText(
                  'Version : ${controller.buildNumber} (${controller.version})',
                  textAlign: TextAlign.center,
                  color: AppColors.darkBlueText,
                  fontWeight: FontWeight.w600,
                  fontSize: 20.sp,
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
