/// api call done
import 'dart:convert';
import 'dart:io' as io;

import 'package:avatar_glow/avatar_glow.dart';
import 'package:just_audio/just_audio.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:rxdart/rxdart.dart';
import 'package:voice_buddies/app/models/message_model.dart';
import 'package:voice_buddies/app/modules/home/controllers/home_controller.dart';
import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_container.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_seekbar.dart';
import '../controllers/message_controller.dart';

class MessageView extends GetView<MessageController> {
  const MessageView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<MessageController>(
      init: MessageController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: false,
          isBackButton: true,
          prefSize: 75.h,
          action: [
            GestureDetector(
              onTap: () {
                showDialog(context: context, builder: (BuildContext context) => infoDialog(context));
              },
              child: Container(
                padding: EdgeInsets.symmetric(horizontal: 12.w),
                child: Icon(
                  Icons.info,
                  color: AppColors.yellowGradient2,
                  size: 35.w,
                ),
              ),
            )
          ],
          onTap: () {
            Get.find<HomeController>().getMessageList();
            controller.playerInitial.stop();
            controller.player.stop();
            controller.recordingPlayer.stop();
            Get.back();
          },
          titleWidget: Column(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
            AppText(
              AppStrings.voiceRecordingFrom,
              fontSize: 16.sp,
              fontFamily: FontFamily.montserratRegular,
              color: AppColors.darkBlue600,
              fontWeight: FontWeight.w500,
            ),
            SizedBox(
              height: 4.h,
            ),
            AppText(
              controller.userName.value,
              fontSize: 22.sp,
              fontFamily: FontFamily.montserratRegular,
              color: AppColors.blackAppbar,
              fontWeight: FontWeight.w600,
            ),
          ]),
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: Theme(
              data: ThemeData(primaryColor: AppColors.greenGradient1),
              child: SmartRefresher(
                controller: controller.refreshController,
                onRefresh: () async {
                  try {
                    controller.getMessageList();
                    controller.refreshController.refreshCompleted();
                  } catch (e) {
                    controller.refreshController.refreshCompleted();
                  }
                },
                child: StreamBuilder<PositionData>(
                    stream: Rx.combineLatest3<Duration, Duration, Duration?, PositionData>(
                      controller.player.positionStream,
                      controller.player.bufferedPositionStream,
                      controller.player.durationStream,
                      (position, bufferedPosition, duration) => PositionData(
                        position,
                        bufferedPosition,
                        duration ?? Duration.zero,
                      ),
                    ).asBroadcastStream(),
                    builder: (context, snapshot) {
                      final positionData = snapshot.data;

                      Widget newAndOldMessageView({required onlyThree}) {
                        return ListView.builder(
                          itemCount: (onlyThree)
                              ? controller.messageList.length > 3
                                  ? 3
                                  : controller.messageList.length
                              : controller.messageList.length - 3,
                          shrinkWrap: true,
                          // controller: controller.scrollController,
                          padding: EdgeInsets.only(top: 15.h),
                          physics: const NeverScrollableScrollPhysics(),
                          itemBuilder: (context, index) {
                            MessageData message = (onlyThree) ? controller.messageList[index] : controller.messageList[index + 3];
                            printAction("message id ${message.msgId}");
                            int useIdex = (onlyThree) ? index : index + 3;
                            return Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                CommonContainer(
                                  isBottomLeft: true,
                                  isBorderRadius: true,
                                  borderRadius: 10.r,
                                  isHeight: false,
                                  padding: EdgeInsets.symmetric(vertical: 10.h),
                                  child: Padding(
                                    padding: EdgeInsets.only(right: 0.w),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Column(
                                            crossAxisAlignment: CrossAxisAlignment.start,
                                            children: [
                                              Container(
                                                margin: EdgeInsets.zero,
                                                padding: EdgeInsets.only(top: 8.h),
                                                // height: 10.h,
                                                width: double.infinity,
                                                child: Padding(
                                                  padding: EdgeInsets.only(left: 8.w, right: 8.w, top: 0),
                                                  child: Column(
                                                    crossAxisAlignment: CrossAxisAlignment.start,
                                                    children: [
                                                      controller.currentIndex.value == useIdex
                                                          ? AudioSeekBar(
                                                              duration: positionData?.duration ?? Duration.zero,
                                                              position: positionData?.position ?? Duration.zero,
                                                              bufferedPosition: positionData?.bufferedPosition ?? Duration.zero,
                                                              audioPlayer: controller.player,
                                                              onChangeEnd: (newPosition) {
                                                                controller.player.seek(newPosition);
                                                              },
                                                            )
                                                          : AudioSeekBar(
                                                              duration: Duration.zero,
                                                              position: Duration.zero,
                                                              bufferedPosition: Duration.zero,
                                                              audioPlayer: controller.playerInitial,
                                                              onChangeEnd: (newPosition) {
                                                                controller.playerInitial.seek(newPosition);
                                                              },
                                                            ),
                                                      Padding(
                                                        padding: EdgeInsets.only(left: 10.w, top: 6.h),
                                                        child: AppText(
                                                          controller.currentIndex.value == useIdex ? RegExp(r'((^0*[1-9]\d*:)?\d{2}:\d{2})\.\d+$').firstMatch("${positionData?.position ?? Duration.zero}")!.group(1)! : RegExp(r'((^0*[1-9]\d*:)?\d{2}:\d{2})\.\d+$').firstMatch("${Duration.zero}")!.group(1)!,
                                                          color: AppColors.darkBlue500,
                                                          fontWeight: FontWeight.w400,
                                                          fontFamily: FontFamily.montserratRegular,
                                                          textAlign: TextAlign.left,
                                                          fontSize: 12.sp,
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                        StreamBuilder<PlayerState>(
                                            stream: controller.player.playerStateStream,
                                            builder: (context, snapshot) {
                                              return Padding(
                                                padding: EdgeInsets.only(top: 10.w),
                                                child: GestureDetector(
                                                  onTap: () async {
                                                    controller.recordingPlayer.playing ? controller.recordingPlayer.pause() : null;
                                                    if (controller.recorderController!.isRecording) {
                                                      utils.showToast(message: AppStrings.pleaseStopRecordingToPlay);
                                                    } else {
                                                      if (controller.currentIndex.value == useIdex) {
                                                        if (snapshot.data?.processingState == ProcessingState.completed) {
                                                          controller.player.pause();
                                                          controller.player.seek(Duration.zero);
                                                        }
                                                        controller.player.playing ? await controller.player.pause() : await controller.player.play();
                                                      } else {
                                                        controller.currentIndex.value = useIdex;
                                                        controller.update();
                                                        controller.player.playing ? await controller.player.pause() : null;
                                                        if (message.msg!.isURL) {
                                                          await controller.player.setAudioSource(
                                                            AudioSource.uri(Uri.parse(message.msg!)),
                                                          );

                                                          await controller.player.setAudioSource(AudioSource.uri(Uri.parse(message.msg!))).then((value) => controller.player.play());
                                                          controller.update();
                                                        } else {
                                                          await controller.player.setAudioSource(AudioSource.file(message.msg!));
                                                          await controller.player.setAudioSource(AudioSource.file(message.msg!)).then((value) => controller.player.play());
                                                          controller.update();
                                                        }
                                                        controller.update();
                                                      }
                                                    }

                                                    printAction("controller.currentIndex.value at end${controller.currentIndex.value}");
                                                    printAction("index end=$useIdex");

                                                    controller.update();
                                                  },
                                                  child: Image.asset(
                                                    AppImages.icGreenPlay,
                                                    height: 40.h,
                                                    width: 40.w,
                                                  ),
                                                ),
                                              );
                                            }),
                                        Padding(
                                          padding: EdgeInsets.only(right: 10.w),
                                          child: (controller.isDelete == 0)
                                              ? Container(
                                                  padding: EdgeInsets.zero,
                                                  height: 15.h,
                                                  width: 18.w,
                                                  child: PopupMenuButton(
                                                    position: PopupMenuPosition.over,
                                                    shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10.r)),
                                                    icon: Image.asset(
                                                      AppImages.icStar,
                                                      height: 15.h,
                                                      width: 15.w,
                                                    ),
                                                    padding: EdgeInsets.zero,
                                                    onSelected: (value) {
                                                      if (value == 0) {
                                                        controller.player.pause();
                                                        controller.msgDeleteApi(messageIndex: useIdex, messageId: message.msgId);
                                                      } else if (value == 1) {
                                                        controller.player.pause();
                                                        controller.download(voiceUrl: message.msg.toString());
                                                        controller.player.play();
                                                      } else if (value == 2) {
                                                        controller.player.pause();
                                                        printAction("message mokal vi savi ${jsonEncode(message)}");
                                                        Get.toNamed(Routes.FLAG, arguments: message);
                                                      } else {
                                                        if (controller.loginData?.userId.toString() != message.senderId) {
                                                          controller.player.pause();
                                                          controller.unBlockUserApi(blockedUserId: message.senderId);
                                                        }
                                                      }
                                                      controller.update();
                                                    },
                                                    itemBuilder: (BuildContext bc) {
                                                      return [
                                                        if (message.senderId.toString() == controller.loginData!.userId.toString())
                                                          PopupMenuItem(
                                                            value: 0,
                                                            padding: EdgeInsets.fromLTRB(12.w, 5.h, 12.w, 12.h),
                                                            // height: 0.h,
                                                            child: Column(
                                                              children: [
                                                                Row(
                                                                  children: [
                                                                    Image.asset(
                                                                      AppImages.icDelete,
                                                                      height: 18.h,
                                                                      width: 18.w,
                                                                    ),
                                                                    SizedBox(width: 8.w),
                                                                    AppText(
                                                                      AppStrings.delete,
                                                                      color: AppColors.darkBlue600,
                                                                      fontSize: 14.sp,
                                                                      fontFamily: FontFamily.montserratRegular,
                                                                      fontWeight: FontWeight.w500,
                                                                    ),
                                                                  ],
                                                                ),
                                                                SizedBox(height: 10.h),
                                                                Divider(
                                                                  height: 1.h,
                                                                  color: AppColors.darkBlue100,
                                                                  thickness: 1.h,
                                                                ),
                                                              ],
                                                            ),
                                                          ),
                                                        PopupMenuItem(
                                                          value: 1,
                                                          padding: EdgeInsets.fromLTRB(12.w, 0, 12.w, 12.h),
                                                          height: 0.h,
                                                          child: Column(
                                                            children: [
                                                              Row(
                                                                children: [
                                                                  Image.asset(
                                                                    AppImages.icDownload,
                                                                    height: 18.h,
                                                                    width: 18.w,
                                                                  ),
                                                                  SizedBox(width: 8.w),
                                                                  AppText(
                                                                    AppStrings.download,
                                                                    color: AppColors.darkBlue600,
                                                                    fontSize: 14.sp,
                                                                    fontFamily: FontFamily.montserratRegular,
                                                                    fontWeight: FontWeight.w500,
                                                                  ),
                                                                ],
                                                              ),
                                                              SizedBox(height: 10.h),
                                                              Divider(
                                                                height: 1.h,
                                                                color: AppColors.darkBlue100,
                                                                thickness: 1.h,
                                                              ),
                                                            ],
                                                          ),
                                                        ),
                                                        if (message.senderId.toString() != controller.loginData!.userId.toString())
                                                          PopupMenuItem(
                                                            value: 2,
                                                            padding: EdgeInsets.fromLTRB(12.w, 0, 12.w, 12.h),
                                                            height: 0.h,
                                                            child: Column(
                                                              children: [
                                                                Row(
                                                                  children: [
                                                                    Image.asset(
                                                                      AppImages.icFlag,
                                                                      height: 18.h,
                                                                      width: 18.w,
                                                                    ),
                                                                    SizedBox(width: 8.w),
                                                                    AppText(
                                                                      AppStrings.flag,
                                                                      color: AppColors.darkBlue600,
                                                                      fontSize: 14.sp,
                                                                      fontFamily: FontFamily.montserratRegular,
                                                                      fontWeight: FontWeight.w500,
                                                                    ),
                                                                  ],
                                                                ),
                                                                SizedBox(height: 10.h),
                                                                Divider(
                                                                  height: 1.h,
                                                                  color: AppColors.darkBlue100,
                                                                  thickness: 1.h,
                                                                ),
                                                              ],
                                                            ),
                                                          ),
                                                        if (message.senderId.toString() != controller.loginData!.userId.toString())
                                                          PopupMenuItem(
                                                            value: 3,
                                                            padding: EdgeInsets.fromLTRB(12.w, 0, 12.w, 8.h),
                                                            height: 0.h,
                                                            child: Column(
                                                              mainAxisAlignment: MainAxisAlignment.start,
                                                              children: [
                                                                Row(
                                                                  children: [
                                                                    Image.asset(
                                                                      AppImages.icBlock,
                                                                      height: 18.h,
                                                                      width: 18.w,
                                                                    ),
                                                                    SizedBox(width: 8.w),
                                                                    AppText(
                                                                      AppStrings.block,
                                                                      color: AppColors.darkBlue600,
                                                                      fontSize: 14.sp,
                                                                      fontFamily: FontFamily.montserratRegular,
                                                                      fontWeight: FontWeight.w500,
                                                                    ),
                                                                  ],
                                                                ),
                                                              ],
                                                            ),
                                                          ),
                                                      ];
                                                    },
                                                  ),
                                                )
                                              : SizedBox(),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                                SizedBox(height: 6.h),
                                AppText(
                                  // "${DateFormat.yMMMd('en_US').format(DateTime.parse(message.createdAt!)).split(",").first}, ${DateTime.parse(message.createdAt!).hour.toString().padLeft(2, "0")}:${DateTime.parse(message.createdAt!).minute.toString().padLeft(2, "0")}",
                                  controller.getLocalDate(createdAt: message.createdAt), color: AppColors.greyBlue,
                                  fontWeight: FontWeight.w400,
                                  textAlign: TextAlign.left,
                                  fontSize: 12.sp,
                                ),
                                SizedBox(
                                  height: 15.h,
                                )
                              ],
                            );
                          },
                        );
                      }

                      return ListView(
                        physics: const BouncingScrollPhysics(),
                        padding: EdgeInsets.zero,
                        // controller: controller.scrollController,
                        addAutomaticKeepAlives: false,
                        shrinkWrap: true,
                        children: [
                          SizedBox(height: 15.h),
                          AppText(
                            (controller.isDelete == 0) ? AppStrings.recordAndSendAVoiceRecording : AppStrings.accountHasBeenDeleted,
                            fontSize: 16.sp,
                            textAlign: TextAlign.center,
                            fontFamily: FontFamily.montserratRegular,
                            color: AppColors.black,
                            fontWeight: FontWeight.w500,
                          ),
                          SizedBox(height: 15.h),
                          if (controller.isDelete == 0)
                            CommonContainer(
                              isBorderRadius: true,
                              borderRadius: 10.r,
                              isHeight: false,
                              padding: EdgeInsets.symmetric(vertical: 6.h),
                              child: Column(
                                children: [
                                  Padding(
                                    padding: EdgeInsets.only(right: 16.w, left: 7.w),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        GestureDetector(
                                          onTap: () async {
                                            controller.player.playing ? controller.player.pause() : null;
                                            controller.recordingPlayer.playing ? controller.player.pause() : null;
                                            if (controller.recorderController?.isRecording == false) {
                                              controller.maxDuration = Duration.zero;
                                              controller.startOrStopRecording();
                                            } else {
                                              await controller.recorderController!.stop(false);
                                              controller.isRecording = false;
                                              controller.stopTimer(resets: false);
                                              controller.maxDuration = Duration.zero;
                                              controller.loadRecordingToPlayer();
                                            }
                                          },
                                          child: AvatarGlow(
                                            glowColor: Colors.blue,
                                            endRadius: 40.r,
                                            animate: controller.recorderController!.isRecording,
                                            duration: const Duration(seconds: 1),
                                            repeat: true,
                                            showTwoGlows: false,
                                            repeatPauseDuration: const Duration(milliseconds: 100),
                                            child: CircleAvatar(
                                              backgroundColor: AppColors.greenGradient3,
                                              radius: 30.r,
                                              child: Image.asset(
                                                AppImages.icGreenMike,
                                                height: 80.h,
                                                width: 80.w,
                                              ),
                                            ),
                                          ),
                                        ),
                                        StreamBuilder<PlayerState>(
                                            stream: controller.recordingPlayer.playerStateStream,
                                            builder: (context, snapshot) {
                                              return GestureDetector(
                                                onTap: () async {
                                                  controller.player.playing ? controller.player.pause() : null;
                                                  await io.File(controller.path!).exists();
                                                  if (io.File(controller.path!).existsSync()) {
                                                    if (snapshot.data?.processingState == ProcessingState.completed) {
                                                      controller.recordingPlayer.pause();
                                                      controller.recordingPlayer.seek(Duration.zero);
                                                    }
                                                    controller.recordingPlayer.playing ? controller.recordingPlayer.pause() : controller.recordingPlayer.play();
                                                  } else {
                                                    utils.showToast(message: AppStrings.recordingNotFound);
                                                  }
                                                },
                                                child: Image.asset(
                                                  AppImages.icGreenPlay,
                                                  height: 60.h,
                                                  width: 60.w,
                                                ),
                                              );
                                            }),
                                        controller.isRecorded.value == false
                                            ? Container(
                                                height: 60.h,
                                                width: 60.w,
                                              )
                                            : GestureDetector(
                                                onTap: () {
                                                  if (controller.isRecorded.value) {
                                                    controller.sendChatMediaApi();
                                                  } else {
                                                    utils.showToast(message: AppStrings.pleaseRecordMessageToSend);
                                                  }
                                                },
                                                child: Image.asset(
                                                  AppImages.icGreenSend,
                                                  height: 60.h,
                                                  width: 60.w,
                                                ),
                                              ),
                                      ],
                                    ),
                                  ),
                                  Container(
                                    margin: EdgeInsets.only(top: 5.h, bottom: 8.h, left: 7.w, right: 2.w),
                                    child: StreamBuilder<PositionData>(
                                      stream: controller.positionDataStream,
                                      builder: (context, snapshot) {
                                        final positionData = snapshot.data;
                                        return Padding(
                                          padding: EdgeInsets.only(left: 8.w, right: 8.w),
                                          child: Row(
                                            crossAxisAlignment: CrossAxisAlignment.center,
                                            mainAxisAlignment: MainAxisAlignment.start,
                                            children: [
                                              Expanded(
                                                child: AudioSeekBar(
                                                  duration: positionData?.duration ?? Duration.zero,
                                                  position: positionData?.position ?? Duration.zero,
                                                  bufferedPosition: positionData?.bufferedPosition ?? Duration.zero,
                                                  audioPlayer: controller.recordingPlayer,
                                                  onChangeEnd: (newPosition) {
                                                    controller.recordingPlayer.seek(newPosition);
                                                  },
                                                ),
                                              ),
                                              Padding(
                                                padding: EdgeInsets.only(right: 5.w),
                                                child: Container(
                                                  width: 45.w,
                                                  child: AppText(
                                                    RegExp(r'((^0*[1-9]\d*:)?\d{2}:\d{2})\.\d+$').firstMatch("${positionData?.position ?? Duration.zero}")!.group(1)!,
                                                    color: AppColors.darkBlue500,
                                                    fontWeight: FontWeight.w400,
                                                    fontFamily: FontFamily.montserratRegular,
                                                    textAlign: TextAlign.left,
                                                    fontSize: 12.sp,
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        );
                                      },
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          SizedBox(height: 40.h),
                          controller.messageList.isEmpty
                              ? Container()
                              : AppText(
                                  AppStrings.newMessages,
                                  color: AppColors.darkBlueText,
                                  fontWeight: FontWeight.w600,
                                  fontSize: 16.sp,
                                ),
                          controller.messageList.isEmpty && controller.isNoData.value
                              ? Center(
                                  child: Column(
                                    children: [
                                      AppText(
                                        AppStrings.noDataFound,
                                        color: AppColors.darkBlue700,
                                        fontFamily: FontFamily.montserratRegular,
                                        fontWeight: FontWeight.w500,
                                        fontSize: 20.sp,
                                      ),
                                    ],
                                  ),
                                )
                              : newAndOldMessageView(onlyThree: true),
                          controller.messageList.isEmpty ? Container() : Divider(color: AppColors.darkBlue100, thickness: 1.h),
                          SizedBox(height: 10.h),
                          controller.messageList.isEmpty
                              ? Container()
                              : Row(
                                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                  children: [
                                    GestureDetector(
                                      onTap: () {},
                                      child: AppText(
                                        AppStrings.oldMessages,
                                        color: AppColors.darkBlue500,
                                        fontWeight: FontWeight.w500,
                                        textAlign: TextAlign.left,
                                        fontSize: 16.sp,
                                      ),
                                    ),
                                    GestureDetector(
                                      onTap: () {
                                        Get.toNamed(Routes.CONTACT_US);
                                      },
                                      child: AppText(
                                        AppStrings.help,
                                        color: AppColors.darkBlue500,
                                        fontWeight: FontWeight.w500,
                                        textAlign: TextAlign.left,
                                        fontSize: 16.sp,
                                      ),
                                    ),
                                  ],
                                ),
                          if (controller.messageList.length > 3) newAndOldMessageView(onlyThree: false),
                          SizedBox(height: 30.h),
                        ],
                      );
                    }),
              ),
            ),
          ),
        );
      },
    );
  }

  Widget infoDialog(BuildContext context) {
    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(12.0)), //this right here
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: 20.w, vertical: 20.h),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            AppText(
              AppStrings.howItWorks,
              fontSize: 20.sp,
              fontFamily: FontFamily.montserratRegular,
              color: AppColors.black,
              fontWeight: FontWeight.w500,
            ),
            SizedBox(height: 10.h),
            Divider(color: AppColors.greyBG, height: 1, thickness: 2.h),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icGreenMike,
                  height: 20.h,
                  width: 20.w,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.tapGreenMike,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icGreenPlay,
                  height: 20.h,
                  width: 20.w,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.tapGreenPlay,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icGreenSend,
                  height: 20.h,
                  width: 20.w,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.tapGreenSend,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            CommonButton(
                onTap: () {
                  Get.back();
                },
                buttonTitle: AppStrings.gotIt)
          ],
        ),
      ),
    );
  }
}
