import 'package:voice_buddies/app/api_repository/api_class.dart';
import 'package:voice_buddies/app/models/login_model.dart';
import 'package:voice_buddies/app/utils/all_imports.dart';

class OtpController extends GetxController {
  TextEditingController email = TextEditingController();
  RxString pinController = ''.obs;
  FocusNode focusNode = FocusNode();
  GlobalKey<FormState> otpFormKey = GlobalKey<FormState>();
  RxString id = "".obs;
  RxString firstName = "".obs;
  RxString password = "".obs;
  RxString selectedGender = "".obs;
  RxString selectedAge = "".obs;
  RxString selectedCurrentlyIAm = "".obs;
  RxString selectedCountry = "".obs;
  RxString selectedLanguage = "".obs;
  RxString path = "".obs;
  RxString ccode = "".obs;
  RxString phone = "".obs;

  RxBool isSignUp = false.obs;

  bool isOTPValidation() {
    if (pinController.value.isEmpty) {
      utils.showToast(message: AppStrings.errorMessageOtp);
      return false;
    } else if (pinController.value.length != 4) {
      utils.showToast(message: AppStrings.errorMessageValidOTP);
      return false;
    }
    return true;
  }

  @override
  void onInit() {
    if (Get.arguments != null) {
      isSignUp.value = Get.arguments[0];
      id.value = Get.arguments[1] ?? '';
      firstName.value = Get.arguments[2];
      email.text = Get.arguments[3];
      password.value = Get.arguments[4];
      selectedGender.value = Get.arguments[5];
      selectedAge.value = Get.arguments[6];
      selectedCurrentlyIAm.value = Get.arguments[7];
      selectedCountry.value = Get.arguments[8];
      selectedLanguage.value = Get.arguments[9];
      path.value = Get.arguments[10];
      ccode.value = Get.arguments[11];
      phone.value = Get.arguments[12];
    }
    super.onInit();
  }

  /// SignUp Api
  signUpApi() async {
    FormData formData = FormData.fromMap({
      "fname": firstName.value,
      "email": email.text,
      "password": utils.generateMd5(password.value),
      "gender": selectedGender.value,
      "age": selectedAge.value,
      "i_am": selectedCurrentlyIAm.value,
      "i_live": selectedCountry.value,
      "spoken": selectedLanguage.value,
      "unique_id": id.value,
      "otp": pinController.value,
      HttpUtil.ccode: ccode.value,
      HttpUtil.phone: phone.value,
      if (!utils.isValidationEmpty(path.value)) "voice": MultipartFile.fromFileSync(path.value, filename: path.value.split("/").last),
    });

    final data = await APIFunction().apiCall(
      apiName: Constants.signUp,
      params: formData,
    );

    LoginDataModel model = LoginDataModel.fromJson(data);

    if (model.responseCode == 1) {
      id.value = "";
      firstName.value = "";
      selectedGender.value = "";
      selectedAge.value = "";
      selectedCurrentlyIAm.value = "";
      selectedCountry.value = "";
      selectedLanguage.value = "";
      path.value = "";
      pinController.value = '';
      await getStorageData.saveObject(getStorageData.loginData, model.data!);
      Get.offAllNamed(Routes.DONE_SIGNUP);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }

  /// Verify OTP Api
  verifyOtpApi() async {
    FormData formData = FormData.fromMap({
      "email": email.text,
      "otp": pinController.value,
    });

    final data = await APIFunction().apiCall(
      apiName: Constants.verifyOtp,
      params: formData,
    );

    LoginDataModel model = LoginDataModel.fromJson(data);

    if (model.responseCode == 1) {
      pinController.value = '';
      Get.toNamed(Routes.CREATE_NEW_PASSWORD, arguments: [email.text]);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }

  /// ReSend OTP Api
  resendOTP() async {
    printAction(isSignUp.value.toString());
    FormData formData = FormData.fromMap({
      "email": email.text,
      if (isSignUp.value) HttpUtil.ccode: ccode.value,
      if (isSignUp.value) HttpUtil.phone: phone.value,
    });

    final data = await APIFunction().apiCall(
      apiName: isSignUp.value ? Constants.sendOtp : Constants.forgotPassword,
      params: formData,
    );

    LoginDataModel model = LoginDataModel.fromJson(data);

    if (model.responseCode == 1) {
      pinController.value = '';
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
