import 'package:webview_flutter/webview_flutter.dart';

import '../../../utils/all_imports.dart';
import '../controllers/privacy_policy_controller.dart';

class PrivacyPolicyView extends GetView<PrivacyPolicyController> {
  const PrivacyPolicyView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<PrivacyPolicyController>(
      init: PrivacyPolicyController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: controller.title,
          textColor: AppColors.blackAppbar,
          body: Visibility(
              visible: !controller.isHide,
              child: (controller.webController != null)
                  ? WebViewWidget(
                      controller: controller.webController!,
                    )
                  : const SizedBox()),
        );
      },
    );
  }
}
