import 'package:voice_buddies/app/models/common_model.dart';
import 'package:voice_buddies/app/models/search_model.dart';
import 'package:voice_buddies/app/widget/base_controller.dart';

import '../../../utils/all_imports.dart';

class SearchesController extends BaseController {
  List<SearchResult> searchResult = [];
  TextEditingController nameId = TextEditingController();
  String? selectedGender;
  String? selectedAge;
  String? selectedCurrentlyIAm;
  String? selectedWhereILive;
  RxString selectedSpokenLanguage = "".obs;
  RxInt multipleLangSelectCount = 0.obs;
  RxBool isSelectedMoreThan = false.obs;

  List<String> gender = [
    AppStrings.selectGender,
    AppStrings.male,
    AppStrings.female,
    AppStrings.other,
    AppStrings.decline,
  ];
  List<String> age = [
    AppStrings.selectAge,
    AppStrings.lessThan,
    AppStrings.twentyToTwentyNine,
    AppStrings.fiftyPlus,
    AppStrings.any,
  ];
  List<String> currentlyIAm = [
    AppStrings.selectOccupation,
    AppStrings.atSchool,
    AppStrings.atCollege,
    AppStrings.working,
    AppStrings.inBetweenJobs,
    AppStrings.decline,
  ];
  List<String> whereILive = [
    AppStrings.selectContinent,
    AppStrings.northAmerica,
    AppStrings.southAmerica,
    AppStrings.europe,
    AppStrings.asia,
    AppStrings.australia,
    AppStrings.africa,
  ];

  RxBool isSearchResult = false.obs;
  RxInt moreCount = 1.obs;

  ScrollController scrollController = ScrollController();

  // List<String> spokenLanguage = [
  //   AppStrings.english,
  //   AppStrings.spanish,
  //   AppStrings.french,
  //   AppStrings.german,
  //   AppStrings.arabic,
  //   AppStrings.russian,
  //   AppStrings.portuguese,
  //   AppStrings.mandarin,
  //   AppStrings.cantonese,
  //   AppStrings.korean,
  //   AppStrings.hindi,
  //   AppStrings.bengali,
  //   AppStrings.urdu,
  //   AppStrings.tamil,
  //   AppStrings.telegu,
  //   AppStrings.other,
  // ];

  List<CommonModel> spokenLanguage = [
    CommonModel(name: AppStrings.selectSpokenLan, isSelected: false),
    CommonModel(name: AppStrings.english, isSelected: false),
    CommonModel(name: AppStrings.spanish, isSelected: false),
    CommonModel(name: AppStrings.french, isSelected: false),
    CommonModel(name: AppStrings.german, isSelected: false),
    CommonModel(name: AppStrings.arabic, isSelected: false),
    CommonModel(name: AppStrings.russian, isSelected: false),
    CommonModel(name: AppStrings.portuguese, isSelected: false),
    CommonModel(name: AppStrings.mandarin, isSelected: false),
    CommonModel(name: AppStrings.cantonese, isSelected: false),
    CommonModel(name: AppStrings.korean, isSelected: false),
    CommonModel(name: AppStrings.hindi, isSelected: false),
    CommonModel(name: AppStrings.bengali, isSelected: false),
    CommonModel(name: AppStrings.urdu, isSelected: false),
    CommonModel(name: AppStrings.tamil, isSelected: false),
    CommonModel(name: AppStrings.telugu, isSelected: false),
    CommonModel(name: AppStrings.other, isSelected: false),
  ];

  @override
  void onInit() {
    getUserData();
    super.onInit();
  }

  /// searchApi
  searchApi() async {
    printAction("gender = $selectedGender");
    printAction("age  = $selectedAge");
    printAction("i_am  = $selectedCurrentlyIAm");
    printAction("i_live  = $selectedWhereILive");
    printAction("user_id  = ${loginData?.userId}");
    printAction("name_or_id  = ${nameId.text}");
    printAction("spoken  = ${spokenLanguage[0].isSelected ? "" : selectedSpokenLanguage.value}");
    FormData formData = FormData.fromMap({
      "user_id": loginData?.userId,
      "name_or_id": nameId.text,
      "gender": selectedGender ?? "",
      "age": selectedAge ?? "",
      "i_am": selectedCurrentlyIAm ?? "",
      "i_live": selectedWhereILive ?? "",
      "spoken": spokenLanguage[0].isSelected ? "" : selectedSpokenLanguage.value,
    });

    final data = await APIFunction().apiCall(
      apiName: Constants.searchPage,
      params: formData,
      token: loginData?.token,
    );

    SearchModel model = SearchModel.fromJson(data);

    if (model.responseCode == 1) {
      searchResult = model.data!;
      isSearchResult.value = true;
      update();
      Get.toNamed(Routes.SEARCH_RESULT, arguments: searchResult);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
