import 'package:voice_buddies/app/utils/all_imports.dart';
import 'package:voice_buddies/app/widget/common_bottomSheet.dart';
import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_container.dart';
import 'package:voice_buddies/app/widget/common_drop_down.dart';
import 'package:voice_buddies/app/widget/common_textfiled.dart';

import '../controllers/search_controller.dart';

class SearchView extends GetView<SearchesController> {
  const SearchView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SearchesController>(
      init: SearchesController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: false,
          isBackButton: false,
          title: controller.isSearchResult.value ? AppStrings.searchResult : AppStrings.search,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: Column(
              children: [
                Expanded(
                  child: ListView(
                    shrinkWrap: true,
                    physics: const BouncingScrollPhysics(),
                    padding: EdgeInsets.only(bottom: 30.h),
                    children: [
                      SizedBox(height: 10.h),
                      CommonTextFiled(
                        title: AppStrings.searchNameOrID,
                        titleColor: AppColors.darkBlue400,
                        controller: controller.nameId,
                        titleFontWeight: FontWeight.w500,
                        hintText: AppStrings.enterNameOrID.capitalizeFirst,
                      ),
                      SizedBox(height: 20.h),
                      CommonDropDown(
                        title: AppStrings.gender,
                        itemsList: controller.gender,
                        dropdownValue: controller.selectedGender,
                        hint: AppStrings.selectGender,
                        onChanged: (value) {
                          if (value == controller.gender[0]) {
                            controller.selectedGender = null;
                          } else {
                            controller.selectedGender = value!;
                          }

                          controller.update();
                        },
                      ),
                      SizedBox(height: 20.h),
                      CommonDropDown(
                        title: AppStrings.age,
                        itemsList: controller.age,
                        dropdownValue: controller.selectedAge,
                        hint: AppStrings.selectAge,
                        onChanged: (value) {
                          if (value == controller.age[0]) {
                            controller.selectedAge = null;
                          } else {
                            controller.selectedAge = value!;
                          }
                          controller.update();
                        },
                      ),
                      SizedBox(height: 20.h),
                      CommonDropDown(
                        title: AppStrings.occupation,
                        itemsList: controller.currentlyIAm,
                        dropdownValue: controller.selectedCurrentlyIAm,
                        hint: AppStrings.selectOccupation,
                        onChanged: (value) {
                          if (value == controller.currentlyIAm[0]) {
                            controller.selectedCurrentlyIAm = null;
                          } else {
                            controller.selectedCurrentlyIAm = value!;
                          }
                          controller.update();
                        },
                      ),
                      SizedBox(height: 20.h),
                      CommonDropDown(
                        title: AppStrings.location,
                        itemsList: controller.whereILive,
                        dropdownValue: controller.selectedWhereILive,
                        hint: AppStrings.selectContinent,
                        onChanged: (value) {
                          if (value == controller.whereILive[0]) {
                            controller.selectedWhereILive = null;
                          } else {
                            controller.selectedWhereILive = value!;
                          }
                          controller.update();
                        },
                      ),
                      SizedBox(height: 20.h),
                      AppText(
                        AppStrings.spokenLanguages,
                        color: AppColors.darkBlue400,
                        fontFamily: FontFamily.montserratSemiBold,
                        fontSize: 16.sp,
                      ),
                      SizedBox(height: 10.h),
                      GestureDetector(
                        onTap: () async {
                          await languageSelect(context, controller.spokenLanguage, controller).then((value) {
                            controller.selectedSpokenLanguage.value = "";
                            return controller.spokenLanguage.forEach((element) {
                              if (element.isSelected == true) {
                                controller.selectedSpokenLanguage.value != "" ? controller.selectedSpokenLanguage.value = "${controller.selectedSpokenLanguage.value}, ${element.name}" : controller.selectedSpokenLanguage.value = element.name;
                              }
                              controller.update();
                            });
                          });
                        },
                        child: CommonContainer(
                          isBorderRadius: true,
                          borderRadius: 10.r,
                          height: 50.h,
                          padding: EdgeInsets.symmetric(horizontal: 15.w),
                          isHeight: true,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              AppText(
                                controller.selectedSpokenLanguage.value == "" ? AppStrings.selectSpokenLan : controller.selectedSpokenLanguage.value,
                                fontFamily: FontFamily.montserratRegular,
                                color: controller.selectedSpokenLanguage.value == AppStrings.selectSpokenLan || controller.selectedSpokenLanguage.value == "" ? AppColors.darkBlue400 : AppColors.darkBlueText,
                                fontSize: 16.sp,
                                fontWeight: FontWeight.w600,
                              ),
                              Image.asset(
                                AppImages.icDown,
                                height: 24.h,
                              )
                            ],
                          ),
                        ),
                      ),
                      SizedBox(height: 20.h),
                    ],
                  ),
                ),
                CommonButton(
                    buttonTitle: AppStrings.search,
                    onTap: () async {
                      utils.hideKeyboard(context);
                      printAction("  =-=-=-=-=-=-=-=-=-=-=-=->>== ${controller.nameId.text}==${controller.selectedGender}==${controller.selectedAge}==${controller.selectedCurrentlyIAm}${controller.selectedWhereILive} ==${controller.spokenLanguage[0].isSelected} lan ==${controller.selectedSpokenLanguage.value}");

                      if (controller.nameId.text.isNotEmpty || controller.selectedGender != null || controller.selectedAge != null || controller.selectedCurrentlyIAm != null || controller.selectedWhereILive != null || (controller.spokenLanguage[0].isSelected == false && controller.selectedSpokenLanguage.isNotEmpty)) {
                        controller.searchApi();
                      } else {
                        utils.showToast(message: AppStrings.pleaseSelectAtListOneField);
                      }
                    }),
                SizedBox(height: 10.h)
              ],
            ),
          ),
        );
      },
    );
  }

  Future languageSelect(context, List list, SearchesController controller) {
    return CommonBottomSheet(
        context: context,
        child: GetBuilder<SearchesController>(
          builder: (controller) {
            return SizedBox(
              height: Get.height * 0.90,
              child: Column(
                children: [
                  Expanded(
                    child: ListView.builder(
                        shrinkWrap: true,
                        padding: EdgeInsets.all(10.w),
                        physics: const BouncingScrollPhysics(),
                        itemCount: list.length,
                        itemBuilder: (context, index) {
                          return GestureDetector(
                            onTap: () {
                              if (index == 0) {
                                for (var element in list) {
                                  element.isSelected = false;
                                }
                                list[0].isSelected = true;
                                Get.back();
                                controller.update();
                              } else {
                                list[0].isSelected = false;
                                controller.multipleLangSelectCount.value = 0;
                                for (var element in list) {
                                  if (element.isSelected == true) {
                                    controller.multipleLangSelectCount.value++;
                                  }
                                }
                                list.any((element) {
                                  if (controller.multipleLangSelectCount.value < 3) {
                                    if (controller.multipleLangSelectCount.value == 1) {
                                      list[index].isSelected = true;
                                    } else {
                                      list[index].isSelected = !list[index].isSelected;
                                    }
                                    controller.isSelectedMoreThan.value = false;
                                    return true;
                                  } else if (list[index].isSelected == true) {
                                    list[index].isSelected = false;
                                    controller.isSelectedMoreThan.value = false;
                                    return true;
                                  } else {
                                    controller.isSelectedMoreThan.value = true;
                                    utils.showToast(message: "Select up to three languages");
                                  }
                                  return true;
                                });
                              }
                              controller.update();
                            },
                            child: Container(
                              margin: EdgeInsets.only(top: 10.h),
                              width: double.infinity,
                              padding: EdgeInsets.symmetric(vertical: 15.h, horizontal: 15.w),
                              decoration: BoxDecoration(color: AppColors.greyText, borderRadius: BorderRadius.circular(10.r)),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                children: [
                                  list[index].isSelected && list[0].isSelected != true
                                      ? GradientAppText(
                                          list[index].name,
                                          textAlign: TextAlign.center,
                                          fontWeight: FontWeight.w600,
                                          fontSize: 16.sp,
                                        )
                                      : AppText(
                                          list[index].name,
                                          textAlign: TextAlign.center,
                                          color: AppColors.darkBlue600,
                                          fontWeight: FontWeight.w400,
                                          fontSize: 16.sp,
                                        ),
                                  index == 0
                                      ? Container()
                                      : Image.asset(
                                          list[index].isSelected ? AppImages.icCheckOn : AppImages.icCheckOff,
                                          width: 24.w,
                                          height: 24.h,
                                        )
                                ],
                              ),
                            ),
                          );
                        }),
                  ),
                  Padding(
                    padding: EdgeInsets.symmetric(horizontal: 10.w, vertical: 10.w),
                    child: CommonButton(
                      buttonTitle: AppStrings.ok,
                      onTap: () {
                        Get.back();
                      },
                    ),
                  ),
                  // SizedBox(height: 20.h),
                ],
              ),
            );
          },
        ));
  }
}
