import 'package:voice_buddies/app/utils/all_imports.dart';
import 'package:voice_buddies/app/widget/common_container.dart';

import '../controllers/settings_controller.dart';

class SettingsView extends GetView<SettingsController> {
  const SettingsView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SettingsController>(
      init: SettingsController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: false,
          title: AppStrings.settings,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: Column(
              children: [
                GestureDetector(
                  onTap: () {
                    Get.toNamed(Routes.EDIT_PROFILE);
                  },
                  child: CommonContainer(
                    margin: EdgeInsets.only(top: 10.h),
                    height: 70.h,
                    borderRadius: 10.r,
                    isBorderRadius: true,
                    alignment: Alignment.centerLeft,
                    padding: EdgeInsets.symmetric(horizontal: 15.w),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Image.asset(
                          AppImages.icEditProfile,
                          height: 40.h,
                          width: 40.w,
                        ),
                        SizedBox(width: 15.w),
                        Expanded(
                          child: AppText(
                            AppStrings.editProfile,
                            color: AppColors.darkBlueText,
                            fontSize: 16.sp,
                            fontWeight: FontWeight.w600,
                          ),
                        ),
                        // Spacer(),
                        Image.asset(
                          AppImages.icArrowRight,
                          height: 22.h,
                          width: 22.w,
                          color: AppColors.darkBlueText,
                        )
                      ],
                    ),
                  ),
                ),
                GestureDetector(
                  onTap: () {
                    Get.toNamed(Routes.WHO_I_BLOCKED);
                  },
                  child: CommonContainer(
                    margin: EdgeInsets.only(top: 15.h),
                    height: 70.h,
                    borderRadius: 10.r,
                    isBorderRadius: true,
                    alignment: Alignment.centerLeft,
                    padding: EdgeInsets.symmetric(horizontal: 15.w),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Image.asset(
                          AppImages.icBlocked,
                          height: 40.h,
                          width: 40.w,
                        ),
                        SizedBox(width: 15.w),
                        Expanded(
                          child: AppText(
                            AppStrings.whoIBlocked,
                            color: AppColors.darkBlueText,
                            fontSize: 16.sp,
                            fontWeight: FontWeight.w600,
                          ),
                        ),
                        // Spacer(),
                        Image.asset(
                          AppImages.icArrowRight,
                          height: 22.h,
                          width: 22.w,
                          color: AppColors.darkBlueText,
                        )
                      ],
                    ),
                  ),
                ),
                Visibility(
                  visible: false,
                  child: GestureDetector(
                    onTap: () {},
                    child: CommonContainer(
                      margin: EdgeInsets.only(top: 15.h),
                      height: 70.h,
                      borderRadius: 10.r,
                      isBorderRadius: true,
                      alignment: Alignment.centerLeft,
                      padding: EdgeInsets.symmetric(horizontal: 15.w),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Image.asset(
                            AppImages.icNotification,
                            height: 40.h,
                            width: 40.w,
                          ),
                          SizedBox(width: 15.w),
                          Expanded(
                            child: AppText(
                              AppStrings.notification,
                              color: AppColors.darkBlueText,
                              fontSize: 16.sp,
                              fontWeight: FontWeight.w600,
                            ),
                          ),
                          // Spacer(),
                          Image.asset(
                            AppImages.icArrowRight,
                            height: 22.h,
                            width: 22.w,
                            color: AppColors.darkBlueText,
                          )
                        ],
                      ),
                    ),
                  ),
                ),
                GestureDetector(
                  onTap: () {
                    Get.toNamed(Routes.DELETE_ACCOUNT, arguments: [AppStrings.delete]);
                  },
                  child: CommonContainer(
                    margin: EdgeInsets.only(top: 15.h),
                    height: 70.h,
                    borderRadius: 10.r,
                    isBorderRadius: true,
                    alignment: Alignment.centerLeft,
                    padding: EdgeInsets.symmetric(horizontal: 15.w),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Image.asset(
                          AppImages.icYellowDelete,
                          height: 40.h,
                          width: 40.w,
                        ),
                        SizedBox(width: 15.w),
                        Expanded(
                          child: AppText(
                            AppStrings.deleteAccount,
                            color: AppColors.darkBlueText,
                            fontSize: 16.sp,
                            fontWeight: FontWeight.w600,
                          ),
                        ),
                        // Spacer(),
                        Image.asset(
                          AppImages.icArrowRight,
                          height: 22.h,
                          width: 22.w,
                          color: AppColors.darkBlueText,
                        )
                      ],
                    ),
                  ),
                ),
                GestureDetector(
                  onTap: () {
                    Get.toNamed(Routes.DELETE_LOGOUT_CONFIRMATION, arguments: [AppStrings.logout]);
                  },
                  child: CommonContainer(
                    margin: EdgeInsets.only(top: 15.h),
                    height: 70.h,
                    borderRadius: 10.r,
                    isBorderRadius: true,
                    alignment: Alignment.centerLeft,
                    padding: EdgeInsets.symmetric(horizontal: 15.w),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Image.asset(
                          AppImages.icLogOut,
                          height: 40.h,
                          width: 40.w,
                        ),
                        SizedBox(width: 15.w),
                        Expanded(
                          child: AppText(
                            AppStrings.logout,
                            color: AppColors.darkBlueText,
                            fontSize: 16.sp,
                            fontWeight: FontWeight.w600,
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
