import 'package:flutter/gestures.dart';
import 'package:voice_buddies/app/api_repository/api_class.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_button.dart';
import '../../../widget/common_textfiled.dart';
import '../controllers/signup_controller.dart';

class SignupView extends GetView<SignupController> {
  const SignupView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SignupController>(
      init: SignupController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 30.h),
                GradientAppText(
                  AppStrings.createYourProfile,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 26.sp,
                  isGreenGradient: true,
                ),
                SizedBox(height: 40.h),
                /* CommonTextFiled(
                  title: AppStrings.voiceBuddiesID,
                  controller: controller.id,
                  enabled: false,
                  hintText: AppStrings.enterVoiceBuddiesId,
                  prefixIcon: AppImages.icId,
                ),*/
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.firstName,
                  controller: controller.firstName,
                  hintText: AppStrings.enterFirstName,
                  prefixIcon: AppImages.icUser,
                  textCapitalization: TextCapitalization.words,
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.email,
                  controller: controller.email,
                  hintText: AppStrings.enterEmail,
                  prefixIcon: AppImages.email,
                  inputType: TextInputType.emailAddress,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp("[A-Z]")),
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.phoneNumber,
                  controller: controller.phone,
                  maxLines: controller.selectedCountry?.value.example.length,
                  hintText: AppStrings.enterEmail,
                  prefixIcon: AppImages.email,
                  selectCounty: controller.selectedCountry,
                  inputType: TextInputType.number,
                  inputFormat: [
                    FilteringTextInputFormatter.allow(RegExp("[0-9]")),
                  ],
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.password,
                  controller: controller.password,
                  hintText: AppStrings.enterPassword,
                  suffixVisibility: true,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                  isMaxLines: true,
                  maxLines: 1,
                  obscureText: false,
                  enableInteractiveSelection: false,
                  prefixIcon: AppImages.password,
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.confirmPassword,
                  controller: controller.confirmPassword,
                  hintText: AppStrings.enterConfirmPassword,
                  suffixVisibility: true,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                  enableInteractiveSelection: false,
                  isMaxLines: true,
                  maxLines: 1,
                  obscureText: false,
                  prefixIcon: AppImages.password,
                  textInputAction: TextInputAction.done,
                ),
                SizedBox(height: 20.h),
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    GestureDetector(
                      onTap: () => controller.isPrivacyAccept.value = !controller.isPrivacyAccept.value,
                      child: Obx(
                        () => AnimatedContainer(
                          duration: const Duration(milliseconds: 200),
                          height: 23,
                          width: 23,
                          decoration: BoxDecoration(
                            color: Theme.of(context).scaffoldBackgroundColor,
                            borderRadius: BorderRadius.circular(8.r),
                            border: Border.all(color: !controller.isPrivacyAccept.value ? AppColors.greyBlue : AppColors.greenGradient3),
                          ),
                          child: AnimatedOpacity(
                            duration: const Duration(milliseconds: 200),
                            opacity: controller.isPrivacyAccept.value ? 1 : 0,
                            child: controller.isPrivacyAccept.value
                                ? const Center(
                                    child: Icon(
                                      Icons.check_rounded,
                                      size: 19,
                                      color: AppColors.greenGradient3,
                                    ),
                                  )
                                : const SizedBox(),
                          ),
                        ),
                      ),
                    ),
                    SizedBox(width: 10.h),
                    // Row(
                    //   mainAxisAlignment: MainAxisAlignment.start,
                    //   children: [
                    //     AppText(
                    //       AppStrings.iHaveReadThe,
                    //       color: AppColors.darkBlue400,
                    //       fontWeight: FontWeight.w500,
                    //       fontSize: 16.sp,
                    //     ),
                    //     const Text(" "),
                    //     GestureDetector(
                    //       onTap: () {
                    //         Get.toNamed(Routes.TERMS_AND_CONDITIONS);
                    //       },
                    //       child: GradientAppText(
                    //         AppStrings.termsConditions,
                    //         fontWeight: FontWeight.w600,
                    //         fontSize: 16.sp,
                    //       ),
                    //     ),
                    //     AppText(
                    //       AppStrings.andThe,
                    //       color: AppColors.darkBlue400,
                    //       fontWeight: FontWeight.w500,
                    //       fontSize: 16.sp,
                    //     ),
                    //     const Text(" "),
                    //     GestureDetector(
                    //       onTap: () {
                    //         );
                    //       },
                    //       child: GradientAppText(
                    //         AppStrings.privacyPolicy,
                    //         fontWeight: FontWeight.w600,
                    //         fontSize: 16.sp,
                    //       ),
                    //     ),
                    //   ],
                    // )
                    Expanded(
                      child: Center(
                        child: RichText(
                          textAlign: TextAlign.start,
                          softWrap: true,
                          text: TextSpan(
                            text: "${AppStrings.iHaveReadThe} ",
                            style: TextStyle(
                              color: AppColors.darkBlue400,
                              fontWeight: FontWeight.w500,
                              fontSize: 16.sp,
                              fontFamily: FontFamily.montserratMedium,
                            ),
                            children: [
                              TextSpan(
                                text: AppStrings.termsConditions,
                                recognizer: TapGestureRecognizer()
                                  ..onTap = () {
                                    Get.toNamed(Routes.PRIVACY_POLICY, arguments: {
                                      HttpUtil.tital: AppStrings.termsConditions,
                                      HttpUtil.url: Constants.termsConditions,
                                    });
                                  },
                                style: TextStyle(
                                  fontWeight: FontWeight.w500,
                                  fontSize: 16.sp,
                                  color: AppColors.greenGradient3,
                                  fontFamily: FontFamily.montserratMedium,
                                ),
                              ),
                              TextSpan(
                                text: AppStrings.andThe,
                                style: TextStyle(
                                  color: AppColors.darkBlue400,
                                  fontWeight: FontWeight.w500,
                                  fontSize: 16.sp,
                                  fontFamily: FontFamily.montserratMedium,
                                ),
                              ),
                              TextSpan(
                                text: AppStrings.privacyPolicy,
                                recognizer: TapGestureRecognizer()
                                  ..onTap = () {
                                    Get.toNamed(Routes.PRIVACY_POLICY, arguments: {HttpUtil.tital: AppStrings.privacyPolicy.split(".")[0], HttpUtil.url: Constants.privacyPolicy});
                                  },
                                style: TextStyle(
                                  fontWeight: FontWeight.w500,
                                  fontSize: 16.sp,
                                  color: AppColors.greenGradient3,
                                  fontFamily: FontFamily.montserratMedium,
                                ),
                              ),
                            ],
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                SizedBox(height: 30.h),
                CommonButton(
                  buttonTitle: AppStrings.signup,
                  onTap: () {
                    if (controller.isValidation()) {
                      controller.checkEmailApi();
                    }
                  },
                ),
                SizedBox(height: 30.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
