import 'package:audio_waveforms/audio_waveforms.dart';
import 'package:voice_buddies/app/models/common_model.dart';
import 'package:voice_buddies/app/modules/edit_profile/controllers/edit_profile_controller.dart';
import 'package:voice_buddies/app/widget/common_button.dart';

import '../../../utils/all_imports.dart';
import '../controllers/user_details_controller.dart';

class UserDetailsView extends GetView<UserDetailsController> {
  const UserDetailsView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserDetailsController>(
      init: UserDetailsController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          action: [
            Visibility(
              visible: controller.pageNo.value == 6,
              child: GestureDetector(
                onTap: () {
                  showDialog(context: context, builder: (BuildContext context) => infoDialog(context));
                },
                child: Container(
                  padding: EdgeInsets.symmetric(horizontal: 12.w),
                  child: Icon(
                    Icons.info,
                    color: AppColors.yellowGradient2,
                    size: 35.w,
                  ),
                ),
              ),
            ),
            Visibility(
              visible: true,
              child: GestureDetector(
                onTap: () {
                  Get.back();
                },
                child: Container(
                  height: 30.h,
                  width: 30.h,
                  color: AppColors.transparent,
                  margin: EdgeInsets.only(right: 15.w),
                  child: Container(
                    padding: EdgeInsets.all(4.5.h),
                    decoration: BoxDecoration(
                      border: Border.all(color: AppColors.darkBlue200),
                      shape: BoxShape.circle,
                    ),
                    child: Image.asset(
                      AppImages.icClose,
                      color: AppColors.darkBlueText,
                    ),
                  ),
                ),
              ),
            ),
          ],
          isSafeArea: false,
          isBackButton: false /*controller.pageNo.value != 1*/,
          onTap: () {
            printAction('controller.pageNo.value--------<<<<----->>>>>${controller.pageNo.value}');
            controller.recorderController?.stop(false);
            controller.playerController?.pausePlayer();
            if (controller.pageNo.value == 1 || controller.isSignUp.value == false) {
              Get.back();
            } else {
              controller.pageNo.value--;
            }
            controller.update();
          },
          bgImage: AppImages.icRoundBg,
          bgFit: BoxFit.fill,
          child: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w, vertical: 0.h),
            child: Column(
              children: [
                SizedBox(height: 20.h),
                if (controller.isSignUp.value)
                  Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      GradientAppText(
                        "${controller.pageNo.value} / ",
                        textAlign: TextAlign.center,
                        fontWeight: FontWeight.bold,
                        fontSize: 18.sp,
                        isGreenGradient: true,
                      ),
                      AppText(
                        "6",
                        textAlign: TextAlign.center,
                        color: AppColors.darkBlue400,
                        fontWeight: FontWeight.bold,
                        fontSize: 18.sp,
                      ),
                    ],
                  ),
                if (controller.isSignUp.value) SizedBox(height: 30.h),
                GradientAppText(
                  controller.pageNo.value == 1
                      ? AppStrings.gender
                      : controller.pageNo.value == 2
                          ? AppStrings.age
                          : controller.pageNo.value == 3
                              ? AppStrings.currentlyIAm
                              : controller.pageNo.value == 4
                                  ? AppStrings.whereILive
                                  : controller.pageNo.value == 5
                                      ? AppStrings.spokenLanguages
                                      : AppStrings.createVoiceRecording,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 26.sp,
                  isGreenGradient: true,
                ),
                controller.isSelectedMoreThan.value && controller.pageNo.value == 5 ? SizedBox(height: 23.h) : Container(),
                controller.isSelectedMoreThan.value && controller.pageNo.value == 5
                    ? Padding(
                        padding: EdgeInsets.symmetric(horizontal: 20.w),
                        child: AppText(
                          AppStrings.selectUpToThreeLanguage,
                          textAlign: TextAlign.center,
                          color: AppColors.redColor,
                          fontWeight: FontWeight.w400,
                          fontSize: 16.sp,
                        ),
                      )
                    : Container(),
                SizedBox(height: 40.h),
                controller.pageNo.value == 6
                    ? Expanded(child: voiceRecordings(controller: controller))
                    : Expanded(
                        child: ListView.builder(
                          padding: EdgeInsets.zero,
                          physics: const BouncingScrollPhysics(),
                          shrinkWrap: true,
                          itemCount: controller.pageNo.value == 1
                              ? controller.gender.length
                              : controller.pageNo.value == 2
                                  ? controller.age.length
                                  : controller.pageNo.value == 3
                                      ? controller.currentlyIAm.length
                                      : controller.pageNo.value == 4
                                          ? controller.whereILive.length
                                          : controller.spokenLanguage.length,
                          itemBuilder: (context, index) {
                            return commonSelect(
                              controller: controller,
                              index: index,
                              listIndex: controller.pageNo.value,
                              list: controller.pageNo.value == 1
                                  ? controller.gender
                                  : controller.pageNo.value == 2
                                      ? controller.age
                                      : controller.pageNo.value == 3
                                          ? controller.currentlyIAm
                                          : controller.pageNo.value == 4
                                              ? controller.whereILive
                                              : controller.spokenLanguage,
                            );
                          },
                        ),
                      ),
                SizedBox(height: 30.h),
                Padding(
                  padding: EdgeInsets.only(bottom: 32.h),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      GestureDetector(
                        onTap: () {
                          controller.recorderController?.stop(false);
                          // controller.playerController?.stopAllPlayers();
                          controller.playerController!.pausePlayer();
                          if (controller.pageNo.value == 1 || controller.isSignUp.value == false) {
                            Get.back();
                          } else {
                            controller.pageNo.value--;
                          }
                          controller.update();
                        },
                        child: Container(
                          decoration: const BoxDecoration(boxShadow: [
                            BoxShadow(
                              color: Color(0x4C127466),
                              blurRadius: 30,
                              offset: Offset(0, 10),
                              spreadRadius: 0,
                            )
                          ]),
                          child: Image.asset(
                            AppImages.icPrevious,
                            height: 67.h,
                            width: 67.h,
                          ),
                        ),
                      ),
                      const Spacer(),
                      GestureDetector(
                        onTap: () async {
                          if (controller.isSignUp.value == false) {
                            await controller.recorderController!.stop(false);
                            controller.isRecording = false;
                            controller.isStarted.value = true;
                            controller.stopTimer(resets: false);
                            Get.find<EditProfileController>().editedDetails();
                            Get.back(result: [
                              controller.selectedGender.value,
                              controller.selectedAge.value,
                              controller.selectedCurrentlyIAm.value,
                              controller.selectedCountry.value,
                              controller.selectedLanguage.value,
                              controller.path,
                            ]);
                          } else {
                            printAction(" alert issue =-=-=-=-=-=-=-=-=-=-=-=->>${controller.pageNo.value}");
                            if (controller.pageNo.value < 6) {
                              if (controller.selectedGender.value == "" && controller.pageNo.value == 1) {
                                utils.showToast(message: AppStrings.pleaseMakeASelection);
                              } else if (controller.selectedAge.value == "" && controller.pageNo.value == 2) {
                                utils.showToast(message: AppStrings.pleaseMakeASelection);
                              } else if (controller.selectedCurrentlyIAm.value == "" && controller.pageNo.value == 3) {
                                utils.showToast(message: AppStrings.pleaseMakeASelection);
                              } else if (controller.selectedCountry.value == "" && controller.pageNo.value == 4) {
                                utils.showToast(message: AppStrings.pleaseMakeASelection);
                              } else if (controller.selectedLanguage.value == "" && controller.pageNo.value == 5) {
                                utils.showToast(message: AppStrings.pleaseMakeASelection);
                              } else if (controller.isStarted.value == false && controller.pageNo.value == 6) {
                                utils.showToast(message: AppStrings.pleaseRecordSomethingAboutYourself);
                              } else {
                                controller.pageNo.value++;
                              }
                            } else {
                              printAction('isSignup--------<<<<----->>>>>${controller.isSignUp.value}--${controller.pageNo.value}---${controller.isRecording}---${controller.isStarted.value}');

                              if (controller.selectedGender.value != "" && controller.selectedAge.value != "" && controller.selectedCurrentlyIAm.value != "" && controller.selectedCountry.value != "" && controller.selectedLanguage.value != "" && !controller.isRecording && !controller.isTips.value) {
                                if (controller.isSignUp.value) {
                                  controller.sendOTP();
                                } /*else {}*/
                              } else {
                                if (controller.pageNo.value == 6 && controller.isTips.value) {
                                  utils.showToast(message: AppStrings.pleaseRecordSomethingAboutYourself);
                                } else if (controller.pageNo.value == 6 && !controller.isRecording) {
                                  utils.showToast(message: AppStrings.pleaseStopRecorder);
                                }
                              }
                            }
                          }
                          controller.update();
                        },
                        child: Container(
                          decoration: const BoxDecoration(
                            boxShadow: [
                              BoxShadow(
                                color: Color(0x4C127466),
                                blurRadius: 30,
                                offset: Offset(0, 10),
                                spreadRadius: 0,
                              )
                            ],
                          ),
                          child: Image.asset(
                            AppImages.icNextArrow,
                            height: 67.h,
                            width: 67.h,
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  Widget commonSelect({required UserDetailsController controller, int? index, int? listIndex, List? list}) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      children: [
        Padding(
          padding: EdgeInsets.only(bottom: 18.h),
          child: GestureDetector(
            onTap: () {
              if (controller.pageNo.value == 5) {
                controller.multipleLangSelectCount.value = 0;
                list?.forEach((element) {
                  if (element.isSelected == true) {
                    controller.multipleLangSelectCount.value++;
                  }
                });
                list?.any((element) {
                  if (controller.multipleLangSelectCount.value < 3) {
                    list[index!].isSelected = !list[index].isSelected;

                    controller.isSelectedMoreThan.value = false;
                    return true;
                  } else if (list[index!].isSelected == true) {
                    list[index].isSelected = false;
                    controller.isSelectedMoreThan.value = false;
                    return true;
                  } else {
                    controller.isSelectedMoreThan.value = true;
                  }

                  return true;
                });
                controller.selectedLanguage.value = "";
                for (var element in list!) {
                  if (element.isSelected == true) {
                    controller.selectedLanguage.value = controller.selectedLanguage.value == "" ? element.name : "${controller.selectedLanguage.value}, " + element.name;
                  }
                  printAction("controller.selectedLanguage.value==${controller.selectedLanguage.value}");
                }
              } else {
                if (list![index!].isSelected) {
                  list[index].isSelected = false;
                  controller.pageNo.value == 1
                      ? (controller.selectedGender.value = '')
                      : controller.pageNo.value == 2
                          ? (controller.selectedAge.value = '')
                          : controller.pageNo.value == 3
                              ? (controller.selectedCurrentlyIAm.value = '')
                              : controller.pageNo.value == 4
                                  ? (controller.selectedCountry.value = '')
                                  : null;
                } else {
                  list[index].isSelected = true;
                  controller.pageNo.value == 1
                      ? (controller.selectedGender.value = list[index].name)
                      : controller.pageNo.value == 2
                          ? (controller.selectedAge.value = list[index].name)
                          : controller.pageNo.value == 3
                              ? (controller.selectedCurrentlyIAm.value = list[index].name)
                              : controller.pageNo.value == 4
                                  ? (controller.selectedCountry.value = list[index].name)
                                  : null;
                  for (int i = 0; i < list.length; i++) {
                    if (i != index) {
                      list[i].isSelected = false;
                    }
                  }
                }
                printAction('list?[index!].isSelected--------<<<<----->>>>>${list[index].isSelected}');
              }
              controller.update();
            },
            child: Container(
              width: double.infinity,
              padding: EdgeInsets.symmetric(vertical: 15.h, horizontal: 15.w),
              decoration: BoxDecoration(color: AppColors.greyText, borderRadius: BorderRadius.circular(10.r)),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  list?[index!].isSelected
                      ? GradientAppText(
                          list?[index!].name,
                          textAlign: TextAlign.center,
                          fontWeight: FontWeight.w600,
                          fontSize: 16.sp,
                        )
                      : AppText(
                          list?[index!].name,
                          textAlign: TextAlign.center,
                          color: AppColors.darkBlue700,
                          fontWeight: FontWeight.w400,
                          fontSize: 16.sp,
                        ),
                  Image.asset(
                    list?[index!].isSelected ? AppImages.icCheckOn : AppImages.icCheckOff,
                    width: 24.w,
                    height: 24.h,
                  )
                ],
              ),
            ),
          ),
        ),
        Visibility(
          visible: listIndex == 2 && controller.age.length <= 3 && index == controller.age.length - 1,
          child: Padding(
            padding: EdgeInsets.only(bottom: 18.h),
            child: GestureDetector(
              onTap: () {
                controller.age.add(CommonModel(name: AppStrings.thirtyToThirtyNine, isSelected: false));
                controller.age.add(CommonModel(name: AppStrings.fourTyToFourTyNine, isSelected: false));
                controller.age.add(CommonModel(name: AppStrings.fiftyPlus, isSelected: false));
                controller.age.add(CommonModel(name: AppStrings.decline, isSelected: false));
                controller.update();
              },
              child: Container(
                width: double.infinity,
                padding: EdgeInsets.symmetric(vertical: 15.h, horizontal: 15.w),
                decoration: BoxDecoration(color: AppColors.greyText, borderRadius: BorderRadius.circular(10.r)),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    AppText(
                      'More',
                      textAlign: TextAlign.center,
                      color: AppColors.darkBlue700,
                      fontWeight: FontWeight.w400,
                      fontSize: 16.sp,
                    ),
                    Image.asset(
                      AppImages.icCheckOff,
                      width: 24.w,
                      height: 24.h,
                    )
                  ],
                ),
              ),
            ),
          ),
        ),
      ],
    );
  }

  Widget voiceRecordings({UserDetailsController? controller, BuildContext? context}) {
    return Column(
      children: [
        GestureDetector(
          onTap: () {
            controller!.isTips.value = false;
            controller.isRecordingSaved.value = false;
            controller.playerController?.stopAllPlayers();
            controller.playerController?.stopPlayer();
            controller.startOrStopRecording();
            controller.update();
          },
          child: Image.asset(AppImages.icMikeImg, width: 154.h, height: 154.h),
        ),
        SizedBox(height: 25.h),
        SizedBox(
          height: 26.h,
          child: AppText(
            controller!.myWaveformData.isEmpty
                ? (controller.maxDuration.inSeconds == 0 ? " " : controller.maxDuration.inSeconds.toString())
                : controller.eventTimer.value.split('.').first == '0'
                    ? '0'
                    : controller.eventTimer.value.split('.').first,
            textAlign: TextAlign.center,
            color: AppColors.darkBlueText,
            fontWeight: FontWeight.w500,
            fontSize: 18.sp,
          ),
        ),
        Visibility(
          visible: (controller.myWaveformData.isNotEmpty && (controller.playerController != null && controller.path != null)),
          child: Padding(
            padding: EdgeInsets.only(top: 18.h),
            child: AudioFileWaveforms(
              size: Size(250.w, controller.isTips.value ? 0 : 55.h),
              playerController: controller.playerController ?? PlayerController(),
              waveformType: WaveformType.long,
              enableSeekGesture: true,
              continuousWaveform: true,
              waveformData: controller.myWaveformData,
              playerWaveStyle: const PlayerWaveStyle(
                fixedWaveColor: AppColors.darkBlue500,
                liveWaveColor: AppColors.greenGradient1,
                spacing: 6,
              ),
            ),
          ),
        ),
        Visibility(
          visible: controller.myWaveformData.isEmpty && controller.recorderController != null,
          child: Padding(
            padding: EdgeInsets.only(top: 18.h),
            child: AudioWaveforms(
              enableGesture: true,
              padding: EdgeInsets.zero,
              margin: EdgeInsets.zero,
              size: Size(250.w, controller.isTips.value ? 0 : 55.h),
              recorderController: controller.recorderController ?? RecorderController(),
              waveStyle: const WaveStyle(
                waveColor: AppColors.darkBlue700,
                extendWaveform: true,
                scaleFactor: 25,
                showMiddleLine: false,
                spacing: 6,
              ),
            ),
          ),
        ),
        Padding(
          padding: EdgeInsets.only(top: !controller.isTips.value ? 40.h : 0.h),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              /*Visibility(
                visible: controller.isRecording,
                child: Padding(
                  padding: EdgeInsets.only(right: 50.w),
                  child: GestureDetector(
                    onTap: () {
                      controller.isTips.value = false;
                      controller.isRecordingSaved.value = false;
                      controller.playercontroller.stopAllPlayers();
                      controller.playercontroller.stopPlayer();
                      controller.startOrStopRecording();
                      controller.update();
                      printAction('controller.isStarted.value--------<<<<----->>>>>${controller.isStarted.value}');
                      printAction('controller.isRecordingSaved.value--------<<<<----->>>>>${controller.isRecordingSaved.value}');
                      printAction('controller.isTips.value--------<<<<----->>>>>${controller.isTips.value}');
                    },
                    child: Image.asset(
                      AppImages.icGreenPause,
                      height: 50.h,
                      width: 50.h,
                    ),
                  ),
                ),
              ),*/
              !controller.isRecording && !controller.isTips.value
                  ? GestureDetector(
                      onTap: () async {
                        if (!controller.isTickButton.value) {
                          controller.prepareAudioPlayer();
                        } else {
                          controller.playPauseController();
                        }
                        controller.isTickButton.value = true;

                        controller.update();
                      },
                      child: Image.asset(
                        AppImages.icPlay,
                        height: 50.h,
                        width: 50.h,
                      ),
                    )
                  : Image.asset(
                      AppImages.icPlayGrey,
                      height: 50.h,
                      width: 50.h,
                    ),
              SizedBox(width: 50.w),
              GestureDetector(
                onTap: () async {
                  if (controller.isTickButton.value) {
                    // await controller.copyAndRenameAudioFile(controller.path!, controller.path!.split('.').first, 'helloAA');
                    await controller.copyAndRenameAudioFile(controller.path!, controller.destinationPath, controller.destinationFileName);
                    controller.isRecordingSaved.value = true;
                    utils.showToast(message: AppStrings.recordingSaved);
                    controller.update();
                  }
                },
                child: Image.asset(
                  controller.isTickButton.value ? AppImages.icSelected : AppImages.icUnSelected,
                  height: 50.h,
                  width: 50.h,
                ),
              )
            ],
          ),
        ),
        SizedBox(height: controller.isTips.value ? 36.h : 0.h),
        controller.isTips.value
            ? Column(
                children: [
                  AppText(
                    AppStrings.tellPeopleAboutYourSelf,
                    color: Colors.black,
                    fontSize: 18.sp,
                    fontWeight: FontWeight.w500,
                  ),
                  22.verticalSpace,
                  CommonButton(
                    buttonTitle: AppStrings.tips,
                    width: 66.w,
                    height: 46.h,
                    onTap: () {
                      showDialog(context: Get.context!, builder: (BuildContext context) => tipsDialog(context));
                    },
                  ),
                ],
              )
            : const SizedBox(),
      ],
    );
  }

  Widget infoDialog(BuildContext context) {
    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(12.0)), //this right here
      child: Padding(
        padding: EdgeInsets.symmetric(vertical: 20.h),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            AppText(
              AppStrings.tipsForYourVoiceRecording,
              fontSize: 20.sp,
              textAlign: TextAlign.center,
              fontFamily: FontFamily.montserratRegular,
              color: AppColors.black,
              fontWeight: FontWeight.w500,
            ),
            SizedBox(height: 10.h),
            Divider(color: AppColors.greyBG, height: 1, thickness: 2.h),
            SizedBox(height: 20.h),
            Padding(
              padding: EdgeInsets.symmetric(horizontal: 20.w),
              child: Column(
                children: List.generate(controller.suggestionList.length, (index) {
                  return Padding(
                    padding: EdgeInsets.only(bottom: 20.h),
                    child: Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        SizedBox(
                          height: 40.h,
                          width: 40.h,
                          child: Center(
                            child: Image.asset(
                              controller.suggestionList[index].image!,
                              height: index == 2 ? 32.h : 40.h,
                              width: index == 2 ? 32.h : 40.h,
                            ),
                          ),
                        ),
                        10.horizontalSpace,
                        Expanded(
                          child: AppText(
                            controller.suggestionList[index].name,
                            fontSize: 15.sp,
                            fontFamily: FontFamily.montserratRegular,
                            color: AppColors.black,
                            fontWeight: FontWeight.w500,
                          ),
                        ),
                      ],
                    ),
                  );
                }),
              ),
            ),
            /*Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icGreenMike,
                  height: 50.h,
                  width: 50.h,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.pleaseTapThisGreenMikeIcon,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icYellowPlay,
                  height: 50.h,
                  width: 50.h,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.pleaseTapOrangePlayButton,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                SizedBox(
                  height: 50.h,
                  width: 50.h,
                  child: Center(
                    child: Image.asset(
                      height: 45.h,
                      width: 45.h,
                      AppImages.icDone,
                    ),
                  ),
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.pleaseTapTickButton,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icNextArrow,
                  height: 50.h,
                  width: 50.h,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.pleaseTapToCompleteSignUp,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),*/
            Padding(
              padding: EdgeInsets.symmetric(horizontal: 20.w),
              child: CommonButton(
                  onTap: () {
                    Get.back();
                  },
                  buttonTitle: AppStrings.gotIt),
            )
          ],
        ),
      ),
    );
  }

  Widget tipsDialog(BuildContext context) {
    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(12.0)), //this right here
      child: Padding(
        padding: EdgeInsets.symmetric(vertical: 20.h),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            AppText(
              AppStrings.suggestionForYourVoiceRecording,
              fontSize: 20.sp,
              fontFamily: FontFamily.montserratRegular,
              color: AppColors.black,
              textAlign: TextAlign.center,
              height: 1.4,
              fontWeight: FontWeight.w500,
            ),
            SizedBox(height: 10.h),
            Divider(color: AppColors.greyBG, height: 1, thickness: 2.h),
            ListView.builder(
              shrinkWrap: true,
              itemCount: controller.tipsList.length,
              padding: EdgeInsets.zero,
              physics: const ScrollPhysics(),
              itemBuilder: (context, index) {
                return Padding(
                  padding: EdgeInsets.only(top: 20.h, left: 20.w, right: 20.w),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Padding(
                        padding: EdgeInsets.only(top: 4.h),
                        child: Image.asset(
                          AppImages.icInfo,
                          height: 15.h,
                        ),
                      ),
                      12.horizontalSpace,
                      Expanded(
                        child: AppText(
                          controller.tipsList[index].name,
                          fontSize: 15.sp,
                          fontFamily: FontFamily.montserratRegular,
                          color: AppColors.black,
                          fontWeight: FontWeight.w500,
                        ),
                      ),
                    ],
                  ),
                );
              },
            ),
            SizedBox(height: 20.h),
            Padding(
              padding: EdgeInsets.symmetric(horizontal: 20.w),
              child: CommonButton(
                  onTap: () {
                    Get.back();
                  },
                  buttonTitle: AppStrings.gotIt),
            )
          ],
        ),
      ),
    );
  }

// Widget voiceRecordings({UserDetailscontroller controller}) {
//   return Column(
//     children: [
//       Image.asset(AppImages.icMikeImg, width: 154.w, height: 154.h),
//       SizedBox(height: 25.h),
//       AppText(
//         controller!.maxDuration.inSeconds.toString(),
//         textAlign: TextAlign.center,
//         color: AppColors.darkBlueText,
//         fontWeight: FontWeight.w500,
//         fontSize: 18.sp,
//       ),
//       SizedBox(height: 20.h),
//       AudioWaveforms(
//         enableGesture: true,
//         padding: EdgeInsets.zero,
//         margin: EdgeInsets.zero,
//         size: Size(250.w, 55.h),
//         recorderController: controller!.recorderController!,
//         waveStyle: const WaveStyle(
//           waveColor: AppColors.darkBlue700,
//           extendWaveform: true,
//           scaleFactor: 25,
//           showMiddleLine: false,
//           waveThickness: 2,
//           spacing: 7,
//         ),
//       ),
//       SizedBox(height: 40.h),
//       Row(
//         mainAxisAlignment: MainAxisAlignment.center,
//         children: [
//           GestureDetector(
//             onTap: () {
//               if (controller.isStarted.value == false) {
//                 controller.startOrStopRecording();
//                 controller.maxDuration = Duration.zero;
//               } else {
//                 controller.playercontroller.stopAllPlayers();
//                 controller.playercontroller.stopPlayer();
//                 controller.preparePlayer();
//               }
//               controller.update();
//             },
//             child: Image.asset(
//               controller.isStarted.value ? AppImages.icPlay : AppImages.icPlus,
//               height: 50.h,
//               width: 50.w,
//             ),
//           ),
//           SizedBox(width: 50.w),
//           GestureDetector(
//             onTap: () {},
//             child: Image.asset(
//               AppImages.icDone,
//               color: controller.isStarted.value ? AppColors.darkBlue700 : AppColors.darkBlue200,
//               width: 20.w,
//               height: 14.h,
//             ),
//           ),
//         ],
//       ),
//     ],
//   );
// }
}
