import 'package:avatar_glow/avatar_glow.dart';
import 'package:just_audio/just_audio.dart';
import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_container.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_seekbar.dart';
import '../controllers/user_profile_controller.dart';

class UserProfileView extends GetView<UserProfileController> {
  const UserProfileView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserProfileController>(
      init: UserProfileController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: controller.searchResult.fname,
          textColor: AppColors.blackAppbar,
          onTap: () {
            controller.recordingPlayer.stop();
            controller.player.stop();
            controller.recorderController?.stop(true);
            Get.back();
          },
          action: [
            GestureDetector(
              onTap: () {
                printAction('--------<<<<----->>>>>this is called');
                showDialog(context: context, builder: (BuildContext context) => infoDialog(context));
              },
              child: Container(
                padding: EdgeInsets.symmetric(horizontal: 12.w),
                child: Icon(
                  Icons.info,
                  color: AppColors.yellowGradient2,
                  size: 35.w,
                ),
              ),
            )
          ],
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              physics: const ScrollPhysics(),
              padding: EdgeInsets.only(bottom: MediaQuery.of(context).padding.bottom),
              children: [
                CommonContainer(
                  margin: EdgeInsets.only(top: 15.h),
                  height: 100.h,
                  bgImage: const DecorationImage(
                      image: AssetImage(
                        AppImages.icGreenCard,
                      ),
                      fit: BoxFit.fill),
                  borderRadius: 10.r,
                  isBorderRadius: true,
                  alignment: Alignment.topLeft,
                  padding: EdgeInsets.only(left: 20.w),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      AppText(
                        controller.searchResult.fname ?? "",
                        color: AppColors.lightGreen,
                        fontSize: 22.sp,
                        fontWeight: FontWeight.bold,
                      ),
                      SizedBox(height: 8.h),
                      GradientAppText(
                        controller.searchResult.uniqueId ?? "",
                        isGreenGradient: false,
                        fontSize: 18.sp,
                        fontWeight: FontWeight.w500,
                      ),
                    ],
                  ),
                ),
                SizedBox(height: 20.h),
                AppText(
                  AppStrings.aboutMe,
                  color: AppColors.darkBlueText,
                  fontSize: 18.sp,
                  fontWeight: FontWeight.w600,
                ),
                SizedBox(height: 20.h),
                CommonContainer(
                  isBorderRadius: true,
                  borderRadius: 10.r,
                  isHeight: false,
                  padding: EdgeInsets.symmetric(vertical: 10.h),
                  child: Padding(
                    // padding: EdgeInsets.only(right: 14.w),
                    padding: EdgeInsets.only(right: 0.w),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                margin: EdgeInsets.zero,
                                padding: EdgeInsets.only(top: 4.h),
                                width: double.infinity,
                                child: StreamBuilder<PositionData>(
                                  stream: controller.positionDataStream,
                                  builder: (context, snapshot) {
                                    final positionData = snapshot.data;
                                    printAction('positionData?.position--------<<<<----->>>>>${positionData?.position}');
                                    printAction('positionData?.position total--------<<<<----->>>>>${positionData?.duration}');
                                    return Padding(
                                      padding: EdgeInsets.only(left: 8.w, right: 8.w),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          AudioSeekBar(
                                            duration: positionData?.duration ?? Duration.zero,
                                            position: positionData?.position ?? Duration.zero,
                                            bufferedPosition: positionData?.bufferedPosition ?? Duration.zero,
                                            audioPlayer: controller.player,
                                            onChangeEnd: (newPosition) {
                                              controller.player.seek(newPosition);
                                            },
                                          ),
                                          Padding(
                                            padding: EdgeInsets.only(left: 5.w, top: 8.h),
                                            child: AppText(
                                              int.parse((RegExp(r'((^[1-9]\d*:)?\d{2})\.\d+$').firstMatch("${positionData?.position ?? Duration.zero}")!.group(1)!)).toString(),
                                              color: AppColors.darkBlue500,
                                              fontWeight: FontWeight.w400,
                                              textAlign: TextAlign.left,
                                              fontSize: 12.sp,
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  },
                                ),
                              ),
                            ],
                          ),
                        ),
                        StreamBuilder<PlayerState>(
                            stream: controller.player.playerStateStream,
                            builder: (context, snapshot) {
                              return Padding(
                                padding: EdgeInsets.only(right: 10.w, top: 8.h, bottom: 8.h),
                                child: GestureDetector(
                                  onTap: () async {
                                    printAction('controller.recorderController!.isRecording,first--------<<<<----->>>>>${controller.recorderController!.isRecording}');
                                    if (controller.recorderController!.isRecording) {
                                      utils.showCustomToast(message: AppStrings.pleaseStopRecordingToPlay, context: Get.context!);
                                    } else {
                                      controller.recordingPlayer.playing ? await controller.recordingPlayer.pause() : null;
                                      if (snapshot.data?.processingState == ProcessingState.completed) {
                                        controller.player.pause();
                                        controller.player.seek(Duration.zero);
                                      }
                                      controller.player.playing ? controller.player.pause() : controller.player.play();
                                      controller.update();
                                      printAction('controller.recorderController!.isRecording,second--------<<<<----->>>>>${controller.player.position.inSeconds}');
                                    }
                                  },
                                  child: Image.asset(
                                    AppImages.icYellowPlay,
                                    height: 40.h,
                                    width: 40.w,
                                  ),
                                ),
                              );
                            }),
                      ],
                    ),
                  ),
                ),
                SizedBox(height: 20.h),
                AppText(
                  AppStrings.myDetails,
                  color: AppColors.darkBlueText,
                  fontSize: 18.sp,
                  fontWeight: FontWeight.w600,
                ),
                SizedBox(height: 20.h),
                ListView.builder(
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                  itemCount: controller.userDetails.length,
                  itemBuilder: (context, index) {
                    var userDetail = controller.userDetails[index];
                    return Padding(
                      padding: EdgeInsets.only(bottom: 20.h),
                      child: Column(
                        children: [
                          Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: AppText(
                                  userDetail.name,
                                  color: AppColors.darkBlue400,
                                  fontSize: 16.sp,
                                  fontWeight: FontWeight.w500,
                                ),
                              ),
                              // Spacer(),
                              AppText(
                                userDetail.details,
                                // maxLines: 2,
                                fontFamily: FontFamily.montserratRegular,
                                color: AppColors.darkBlueText,
                                fontSize: 16.sp,
                                fontWeight: FontWeight.w600,
                              ),
                            ],
                          ),
                          SizedBox(height: 10.h),
                        ],
                      ),
                    );
                  },
                ),
                SizedBox(height: 10.h),
                CommonContainer(
                  isBorderRadius: true,
                  borderRadius: 10.r,
                  isHeight: false,
                  padding: EdgeInsets.symmetric(vertical: 6.h),
                  child: Column(
                    children: [
                      Padding(
                        padding: EdgeInsets.only(right: 16.w, left: 7.w),
                        child: Row(
                          children: [
                            Expanded(
                              child: GestureDetector(
                                onTap: () async {
                                  controller.player.playing ? controller.player.pause() : null;
                                  controller.recordingPlayer.playing ? controller.player.pause() : null;
                                  if (controller.recorderController?.isRecording == false) {
                                    controller.maxDuration = Duration.zero;
                                    controller.startOrStopRecording();
                                    controller.isPlayButtonShow = false;
                                  } else {
                                    /*
                                    await controller.recorderController!.stop(false);
                                    controller.isRecording = false;
                                    controller.stopTimer(resets: false);
                                    controller.maxDuration = Duration.zero;
                                    controller.loadRecordingToPlayer();*/
                                  }

                                  printAction('controller.recorderController?.isRecording--------<<<<----->>>>>${controller.recorderController?.isRecording}');
                                },
                                child: AvatarGlow(
                                  glowColor: Colors.blue,
                                  endRadius: 40.r,
                                  animate: controller.recorderController!.isRecording,
                                  duration: const Duration(seconds: 1),
                                  repeat: true,
                                  showTwoGlows: false,
                                  repeatPauseDuration: const Duration(milliseconds: 100),
                                  child: CircleAvatar(
                                    backgroundColor: AppColors.greenGradient3,
                                    radius: 30.r,
                                    child: Image.asset(
                                      AppImages.icGreenMike,
                                      height: 80.h,
                                      width: 80.w,
                                    ),
                                  ),
                                ),
                              ),
                            ),
                            Visibility(
                              visible: true /*controller.recorderController!.isRecording*/,
                              child: Expanded(
                                child: GestureDetector(
                                  onTap: () async {
                                    if (controller.recorderController!.isRecording) {
                                      await controller.recorderController!.stop(false);
                                      controller.isRecording = false;
                                      controller.stopTimer(resets: false);
                                      controller.maxDuration = Duration.zero;
                                      controller.loadRecordingToPlayer();
                                      controller.isPlayButtonShow = true;
                                    }
                                  },
                                  child: Image.asset(
                                    !controller.recorderController!.isRecording ? AppImages.icGreyPause : AppImages.icGreenPause,
                                    height: 60.h,
                                    width: 60.w,
                                  ),
                                ),
                              ),
                            ),
                            Expanded(
                              child: StreamBuilder<PlayerState>(
                                  stream: controller.recordingPlayer.playerStateStream,
                                  builder: (context, snapshot) {
                                    return GestureDetector(
                                      onTap: () async {
                                        printAction('controller.isPlayButtonShow--------<<<<----->>>>>${controller.isPlayButtonShow}');
                                        if (controller.isPlayButtonShow) {
                                          controller.player.playing ? controller.player.pause() : null;
                                          if (controller.recorderController!.isRecording) {
                                            utils.showCustomToast(message: AppStrings.pleaseStopRecordingToPlay, context: Get.context!);
                                          } else {
                                            if (snapshot.data?.processingState == ProcessingState.completed) {
                                              controller.recordingPlayer.pause();
                                              controller.recordingPlayer.seek(Duration.zero);
                                            }
                                            controller.recordingPlayer.playing ? controller.recordingPlayer.pause() : controller.recordingPlayer.play();
                                          }
                                        }
                                      },
                                      child: Image.asset(
                                        !controller.isPlayButtonShow ? AppImages.icGreyPlay : AppImages.icGreenPlay,
                                        height: 60.h,
                                        width: 60.w,
                                      ),
                                    );
                                  }),
                            ),
                            /*controller.isRecordingAvailable == false
                                ? SizedBox(
                                    height: 60.h,
                                    width: 60.w,
                                  )
                                :*/
                            Expanded(
                              child: GestureDetector(
                                onTap: () async {
                                  if (controller.isPlayButtonShow) {
                                    controller.player.playing ? controller.player.pause() : null;
                                    controller.isRecordingAvailable = false;
                                    controller.sendChatMediaApi();
                                    controller.isPlayButtonShow = false;
                                  }
                                  controller.update();
                                },
                                child: Image.asset(
                                  !controller.isPlayButtonShow ? AppImages.icGreySend : AppImages.icGreenSend,
                                  height: 60.h,
                                  width: 60.w,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      Container(
                        margin: EdgeInsets.only(top: 5.h, bottom: 8.h, left: 7.w, right: 2.w),
                        // height: 16.h,
                        child: StreamBuilder<PositionData>(
                          stream: controller.positionDataStreamRecording,
                          builder: (context, snapshot) {
                            final positionDataRecording = snapshot.data;
                            return Padding(
                              padding: EdgeInsets.only(left: 8.w, right: 8.w),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Expanded(
                                    child: AudioSeekBar(
                                      duration: positionDataRecording?.duration ?? Duration.zero,
                                      position: positionDataRecording?.position ?? Duration.zero,
                                      bufferedPosition: positionDataRecording?.bufferedPosition ?? Duration.zero,
                                      audioPlayer: controller.recordingPlayer,
                                      onChangeEnd: (newPosition) {
                                        controller.recordingPlayer.seek(newPosition);
                                      },
                                    ),
                                  ),
                                  Padding(
                                    padding: EdgeInsets.only(right: 5.w),
                                    child: SizedBox(
                                      width: 45.w,
                                      child: AppText(
                                        int.parse(RegExp(r'((^[1-9]\d*:)?\d{2})\.\d+$').firstMatch("${positionDataRecording?.position ?? Duration.zero}")!.group(1)!).toString(),
                                        color: AppColors.darkBlue500,
                                        fontWeight: FontWeight.w400,
                                        fontFamily: FontFamily.montserratRegular,
                                        textAlign: TextAlign.left,
                                        fontSize: 12.sp,
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            );
                          },
                        ),
                      ),
                    ],
                  ),
                ),
                SizedBox(height: 20.h)
              ],
            ),
          ),
        );
      },
    );
  }

  Widget infoDialog(BuildContext context) {
    return Dialog(
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(12.0)), //this right here
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: 20.w, vertical: 20.h),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: <Widget>[
            AppText(
              AppStrings.howItWorks,
              fontSize: 20.sp,
              fontFamily: FontFamily.montserratRegular,
              color: AppColors.black,
              fontWeight: FontWeight.w500,
            ),
            SizedBox(height: 10.h),
            Divider(color: AppColors.greyBG, height: 1, thickness: 2.h),
            SizedBox(height: 20.h),
            Column(
              children: List.generate(controller.suggestionList.length, (index) {
                return Padding(
                  padding: EdgeInsets.only(bottom: 20.h),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      Image.asset(
                        controller.suggestionList[index].image!,
                        height: 40.h,
                        width: 40.w,
                      ),
                      10.horizontalSpace,
                      Expanded(
                        child: AppText(
                          controller.suggestionList[index].name,
                          fontSize: 15.sp,
                          fontFamily: FontFamily.montserratRegular,
                          color: AppColors.black,
                          fontWeight: FontWeight.w500,
                        ),
                      ),
                    ],
                  ),
                );
              }),
            ),
            /*Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icGreenMike,
                  height: 20.h,
                  width: 20.w,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.tapGreenMike,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icGreenPlay,
                  height: 20.h,
                  width: 20.w,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.tapGreenPlay,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),
            Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Image.asset(
                  AppImages.icGreenSend,
                  height: 20.h,
                  width: 20.w,
                ),
                10.horizontalSpace,
                Expanded(
                  child: AppText(
                    AppStrings.tapGreenSend,
                    fontSize: 15.sp,
                    fontFamily: FontFamily.montserratRegular,
                    color: AppColors.black,
                    fontWeight: FontWeight.w500,
                  ),
                ),
              ],
            ),
            SizedBox(height: 20.h),*/
            CommonButton(
                onTap: () {
                  Get.back();
                },
                buttonTitle: AppStrings.gotIt)
          ],
        ),
      ),
    );
  }
}
