import 'package:voice_buddies/app/api_repository/api_class.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_container.dart';
import '../controllers/vb_controller.dart';

class VbView extends GetView<VbController> {
  const VbView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<VbController>(
      init: VbController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: false,
          title: AppStrings.vb,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w, vertical: 10.h),
            child: Column(
              children: [
                ListView.builder(
                    physics: const NeverScrollableScrollPhysics(),
                    shrinkWrap: true,
                    itemCount: controller.vbList.length,
                    itemBuilder: (context, index) {
                      return GestureDetector(
                        onTap: () {
                          index == 0
                              ? Get.toNamed(Routes.PRIVACY_POLICY, arguments: {
                                  HttpUtil.tital: AppStrings.aboutUs,
                                  HttpUtil.url: Constants.aboutUs,
                                })
                              : index == 1
                                  ? Get.toNamed(Routes.PLANS)
                                  : index == 2
                                      ? Get.toNamed(Routes.CONTACT_US)
                                      : index == 3
                                          ? Get.toNamed(Routes.PRIVACY_POLICY, arguments: {
                                              HttpUtil.tital: AppStrings.privacyPolicy.split(".")[0],
                                              HttpUtil.url: Constants.privacyPolicy,
                                            })
                                          : Get.toNamed(Routes.PRIVACY_POLICY, arguments: {
                                              HttpUtil.tital: AppStrings.termsConditions,
                                              HttpUtil.url: Constants.termsConditions,
                                            });
                        },
                        child: CommonContainer(
                          margin: EdgeInsets.only(bottom: 15.h),
                          height: 70.h,
                          borderRadius: 10.r,
                          isBorderRadius: true,
                          alignment: Alignment.centerLeft,
                          padding: EdgeInsets.symmetric(horizontal: 15.w),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Image.asset(
                                controller.vbList[index].image!,
                                height: 40.h,
                                width: 40.w,
                              ),
                              SizedBox(width: 15.w),
                              Expanded(
                                child: AppText(
                                  controller.vbList[index].name,
                                  color: AppColors.darkBlueText,
                                  fontSize: 16.sp,
                                  fontWeight: FontWeight.w600,
                                ),
                              ),
                              // Spacer(),
                              Image.asset(
                                AppImages.icArrowRight,
                                height: 22.h,
                                width: 22.w,
                                color: AppColors.darkBlueText,
                              )
                            ],
                          ),
                        ),
                      );
                    }),
              ],
            ),
          ),
        );
      },
    );
  }
}
