import 'package:simple_gradient_text/simple_gradient_text.dart';
import 'package:voice_buddies/app/utils/all_imports.dart';

class AppText extends StatelessWidget {
  final String text;
  final String? fontFamily;
  final double fontSize;
  final Color? color;
  final FontWeight fontWeight;
  final double? letterSpacing;
  final double? height;
  final TextDecoration textDecoration;
  final TextAlign textAlign;
  final int maxLines;
  final FontStyle fontStyle;

  AppText(
    this.text, {
    this.fontSize = 10,
    this.color,
    this.fontWeight = FontWeight.normal,
    this.fontFamily = FontFamily.montserratRegular,
    this.letterSpacing,
    this.textDecoration = TextDecoration.none,
    this.textAlign = TextAlign.start,
    this.height = 0,
    this.maxLines = 1000,
    this.fontStyle = FontStyle.normal,
  });

  @override
  Widget build(BuildContext context) {
    return Text(
      text,
      textAlign: textAlign,
      maxLines: maxLines,
      softWrap: true,
      overflow: TextOverflow.ellipsis,
      style: TextStyle(
        height: height,
        color: color ?? AppColors.white,
        fontFamily: fontFamily ?? FontFamily.montserratRegular,
        fontSize: fontSize,
        fontWeight: fontWeight,
        fontStyle: fontStyle,
        letterSpacing: letterSpacing,
        decoration: textDecoration,
      ),
    );
  }
}

class GradientAppText extends StatelessWidget {
  final String text;
  final String? fontFamily;
  final double fontSize;
  final Color? color;
  final FontWeight fontWeight;
  final double? letterSpacing;
  final double? height;
  final TextDecoration textDecoration;
  final TextAlign textAlign;
  final int maxLines;
  final FontStyle fontStyle;
  final bool isGreenGradient;
  final List<Color>? gradientColor;

  const GradientAppText(
    this.text, {
    super.key,
    this.fontSize = 16,
    this.color,
    this.fontWeight = FontWeight.normal,
    this.fontFamily = FontFamily.montserratRegular,
    this.letterSpacing,
    this.textDecoration = TextDecoration.none,
    this.textAlign = TextAlign.start,
    this.height = 0,
    this.maxLines = 1000,
    this.fontStyle = FontStyle.normal,
    this.isGreenGradient = true,
    this.gradientColor,
  });

  @override
  Widget build(BuildContext context) {
    return GradientText(
      text,
      textAlign: textAlign,
      maxLines: maxLines,
      gradientDirection: GradientDirection.ltr,
      overflow: TextOverflow.ellipsis,
      gradientType: GradientType.linear,
      style: TextStyle(
        height: height,
        color: color ?? AppColors.white,
        fontFamily: fontFamily ?? FontFamily.montserratRegular,
        fontSize: fontSize,
        fontWeight: fontWeight,
        fontStyle: fontStyle,
        letterSpacing: letterSpacing,
        decoration: textDecoration,
      ),
      colors: gradientColor != null
          ? gradientColor!
          : isGreenGradient
              ? [
                  AppColors.greenGradient1,
                  AppColors.greenGradient2,
                  AppColors.greenGradient3,
                ]
              : [AppColors.yellowGradient1, AppColors.yellowGradient2],
    );
  }
}
