import '../utils/all_imports.dart';

class CommonAppBar extends StatelessWidget implements PreferredSizeWidget {
  final bool? isCenter;
  final String? title;
  final Color? textColor;
  final Color? appbarBgColor;
  final List<Widget>? action;
  final bool isBackButton;
  final double? prefSize;
  final void Function()? onTap;
  final Widget? titleWidget;

  const CommonAppBar({
    this.isCenter = true,
    this.title,
    this.textColor,
    this.appbarBgColor,
    this.action,
    this.onTap,
    this.isBackButton = true,
    this.titleWidget,
    this.prefSize,
  });

  // @override
  // Size get preferredSize => Size.fromHeight(AppBar().preferredSize.height);
  @override
  Widget build(BuildContext context) {
    return AppBar(
      elevation: 0,
      systemOverlayStyle: SystemUiOverlayStyle.dark,
      backgroundColor: appbarBgColor ?? AppColors.transparent,
      centerTitle: isCenter,
      toolbarHeight: prefSize,
      title: titleWidget ??
          AppText(
            title ?? "",
            fontSize: 22.sp,
            fontFamily: FontFamily.montserratRegular,
            color: textColor ?? AppColors.white,
            fontWeight: FontWeight.w600,
          ),
      leading: !isBackButton
          ? Container()
          : Container(
              color: Colors.transparent,
              child: GestureDetector(
                onTap: onTap ??
                    () {
                      Get.back();
                    },
                child: Center(
                  child: Container(
                    color: AppColors.transparent,
                    height: 50.h,
                    width: 50.h,
                    child: Padding(
                      padding: EdgeInsets.symmetric(vertical: 10.h, horizontal: 10.h),
                      child: Container(
                        padding: EdgeInsets.symmetric(vertical: 5.h, horizontal: 5.h),
                        decoration: BoxDecoration(
                          /*   borderRadius: BorderRadius.circular(60.r),*/
                          border: Border.all(color: AppColors.darkBlue200),
                          shape: BoxShape.circle,
                        ),
                        child: Image.asset(
                          AppImages.back,
                          color: AppColors.darkBlueText,
                        ),
                      ),
                    ),
                  ),
                ),
              ),
            ),
      actions: action,
    );
  }

  @override
  Size get preferredSize => Size.fromHeight(prefSize ?? 55.h);
}
