import 'dart:math';

import 'package:just_audio/just_audio.dart';

import '../utils/all_imports.dart';

var isBuffering = false.obs;

class AudioSeekBar extends StatelessWidget {
  final Duration? duration;
  final Duration? position;
  final Duration? bufferedPosition;
  final ValueChanged<Duration>? onChanged;
  final ValueChanged<Duration>? onChangeEnd;
  final int? index;
  final AudioPlayer audioPlayer;
  void Function()? radioOnTap;

  AudioSeekBar({
    super.key,
    this.duration,
    this.position,
    this.bufferedPosition,
    this.onChanged,
    this.onChangeEnd,
    this.index,
    required this.audioPlayer,
    // this.selectBeatController,
    // this.adminNewsFeedController,
    // this.newsFeedController,
    // this.battleController,
    this.radioOnTap,
  });

  double? _dragValue;

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        SliderTheme(
          data: SliderTheme.of(context).copyWith(
            trackHeight: 2.h,
            thumbColor: AppColors.greenGradient3,
            thumbShape: HiddenThumbComponentShape(),
            overlayShape: const RoundSliderOverlayShape(
              overlayRadius: 10,
            ),
            trackShape: const RectangularSliderTrackShape(),
            activeTrackColor: AppColors.transparent,
            inactiveTrackColor: AppColors.greySliderColor,
          ),
          child: ExcludeSemantics(
            child: Slider(
              min: 0.0,
              max: duration!.inMilliseconds.toDouble(),
              value: min(bufferedPosition!.inMilliseconds.toDouble(), duration!.inMilliseconds.toDouble()),
              onChanged: (value) {
                _dragValue = value;

                if (onChanged != null) {
                  onChanged!(Duration(milliseconds: value.round()));
                }
              },
              onChangeEnd: (value) {
                if (onChangeEnd != null) {
                  onChangeEnd!(Duration(milliseconds: value.round()));
                }
                _dragValue = null;
              },
            ),
          ),
        ),
        SliderTheme(
          data: SliderTheme.of(context).copyWith(
              trackHeight: 2.h,
              thumbColor: AppColors.greenGradient3,
              trackShape: const RectangularSliderTrackShape(),
              thumbShape: RoundSliderThumbShape(
                disabledThumbRadius: 6.r,
                enabledThumbRadius: 6.r,
              ),
              overlayShape: const RoundSliderOverlayShape(
                overlayRadius: 10,
              ),
              activeTrackColor: AppColors.greenGradient3,
              inactiveTrackColor: AppColors.greySliderColor,
              disabledThumbColor: AppColors.greenGradient3),
          child: Slider(
            min: 0.0,
            max: duration!.inMilliseconds.toDouble(),
            value: min(_dragValue ?? position!.inMilliseconds.toDouble(), duration!.inMilliseconds.toDouble()),
            onChanged: (value) {
              _dragValue = value;

              if (onChanged != null) {
                onChanged!(Duration(milliseconds: value.round()));
              }
            },
            onChangeEnd: (value) {
              if (onChangeEnd != null) {
                onChangeEnd!(Duration(milliseconds: value.round()));
              }
              _dragValue = null;
            },
          ),
        ),
      ],
    );
  }

  Duration get _remaining => duration! - position!;
}

class HiddenThumbComponentShape extends SliderComponentShape {
  @override
  Size getPreferredSize(bool isEnabled, bool isDiscrete) => Size.zero;

  @override
  void paint(
    PaintingContext context,
    Offset center, {
    Animation<double>? activationAnimation,
    Animation<double>? enableAnimation,
    bool? isDiscrete,
    TextPainter? labelPainter,
    RenderBox? parentBox,
    SliderThemeData? sliderTheme,
    TextDirection? textDirection,
    double? value,
    double? textScaleFactor,
    Size? sizeWithOverflow,
  }) {}
}

class PositionData {
  final Duration? position;
  final Duration? bufferedPosition;
  final Duration? duration;

  PositionData(
    this.position,
    this.bufferedPosition,
    this.duration,
  );
}
